/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.inmemory;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpression;
import com.hazelcast.webmonitor.metrics.jet.tsdb.SynchronizedTimeSeries;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeries;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeriesImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMetricsStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterMetricsStore.class);
    private final ConcurrentMap<Metric, ConcurrentMap<String, TimeSeries>> metrics = new ConcurrentHashMap();
    private final Cache<String, Long> lastSeenTimestamps;
    private static final long INTERVAL = 1000L;
    private final int numberOfSecondsToKeep;
    private final long millisecondsToKeep;

    public ClusterMetricsStore(int numberOfSecondsToKeep) {
        this.numberOfSecondsToKeep = numberOfSecondsToKeep;
        this.lastSeenTimestamps = Caffeine.newBuilder().expireAfterAccess((long)numberOfSecondsToKeep, TimeUnit.SECONDS).build();
        this.millisecondsToKeep = (long)numberOfSecondsToKeep * 1000L;
    }

    public Stream<TimeSeries> query(Metric metric, TagExpression filter) {
        Map map = (Map)this.metrics.get(metric);
        if (map == null) {
            return Stream.empty();
        }
        return map.values().stream().filter(ts -> filter.matches(ts.tags()));
    }

    public TimeSeries querySingle(Metric metric, TagExpression filter) {
        Map map = (Map)this.metrics.get(metric);
        if (map == null) {
            return TimeSeriesImpl.EMPTY_TIMESERIES;
        }
        return map.values().stream().filter(ts -> filter.matches(ts.tags())).reduce((o, n) -> {
            throw new IllegalStateException("Multiple metrics found for metric=" + String.valueOf(metric) + "filter=" + String.valueOf(filter));
        }).orElse((TimeSeries)TimeSeriesImpl.EMPTY_TIMESERIES);
    }

    public Stream<TimeSeries> all() {
        return this.metrics.values().stream().flatMap(e -> e.values().stream());
    }

    public void storeMetricsCollection(Collection<MetricDataPoint> metricDataPoints) {
        if (metricDataPoints.isEmpty()) {
            return;
        }
        for (MetricDataPoint metricDataPoint : metricDataPoints) {
            String name = metricDataPoint.getName();
            if (!Metric.isPersistent((String)name)) continue;
            Stream<Map.Entry> persistentTagsStream = metricDataPoint.getTags().entrySet().stream().filter(it -> Tag.isPersisted((String)((String)it.getKey())));
            Map<String, String> tags = Stream.concat(persistentTagsStream, Stream.of(Map.entry(Tag.METRIC.getName(), name))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
            long time = metricDataPoint.getTime();
            this.metrics.computeIfAbsent(Metric.forName((String)name), k -> new ConcurrentHashMap()).computeIfAbsent(tags.toString(), k -> new SynchronizedTimeSeries((TimeSeries)new TimeSeriesImpl(tags, 1000L, this.numberOfSecondsToKeep))).storePoint(time, metricDataPoint.getValue());
            String member = tags.get(Tag.MEMBER.getName());
            if (member == null) continue;
            this.lastSeenTimestamps.asMap().compute(member, (k, v) -> v == null ? time : Math.max(v, time));
        }
    }

    void cleanUpDanglingEntries() {
        for (ConcurrentMap tagsToTsMap : this.metrics.values()) {
            tagsToTsMap.values().removeIf(ts -> {
                String member = (String)ts.tags().get(Tag.MEMBER.getName());
                if (member == null) {
                    return true;
                }
                Long lastSeen = (Long)this.lastSeenTimestamps.getIfPresent((Object)member);
                if (lastSeen == null) {
                    return true;
                }
                return ts.getLatestTime() + this.millisecondsToKeep < lastSeen;
            });
        }
    }
}

