/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.imdg.ConnectionManagerMetricsQueryFactory;

public final class ConnectionManagerMetricsQueryFactory {
    private final Query.Builder queryBuilder;

    public ConnectionManagerMetricsQueryFactory(Builder builder) {
        this.queryBuilder = Query.builder().cluster(builder.cluster).member(builder.member).start(builder.start).end(builder.end);
        if (builder.endpoint != null) {
            this.queryBuilder.addTag(Tag.ENDPOINT, builder.endpoint);
        }
    }

    public Query unifiedClientConnectionCountQuery() {
        return this.queryBuilder.metric(Metric.TCP_CONNECTION_CLIENT_COUNT).build();
    }

    public Query activeConnectionCountQuery() {
        return this.queryBuilder.metric(Metric.TCP_CONNECTION_ACTIVE_COUNT).build();
    }

    public Query connectionCountQuery() {
        return this.queryBuilder.metric(Metric.TCP_CONNECTION_COUNT).build();
    }
}

