/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.imdg.CacheMetricsQueryFactory;

public final class CacheMetricsQueryFactory {
    private final Query.Builder queryBuilder;

    private CacheMetricsQueryFactory(Builder builder) {
        this.queryBuilder = Query.builder().cluster(builder.cluster).member(builder.member).addTag(Tag.NAME, builder.fullName).start(builder.start).end(builder.end);
    }

    public Query creationTimeQuery() {
        return this.queryBuilder.metric(Metric.CACHE_CREATION_TIME).build();
    }

    public Query hitCountQuery() {
        return this.queryBuilder.metric(Metric.CACHE_HITS).build();
    }

    public Query missCountQuery() {
        return this.queryBuilder.metric(Metric.CACHE_MISSES).build();
    }

    public Query putCountQuery() {
        return this.queryBuilder.metric(Metric.CACHE_PUTS).build();
    }

    public Query getCountQuery() {
        return this.queryBuilder.metric(Metric.CACHE_GETS).build();
    }

    public Query removeCountQuery() {
        return this.queryBuilder.metric(Metric.CACHE_REMOVALS).build();
    }

    public Query evictCountQuery() {
        return this.queryBuilder.metric(Metric.CACHE_EVICTIONS).build();
    }

    public Query averageGetTimeQuery() {
        return this.queryBuilder.metric(Metric.CACHE_AVERAGE_GET_TIME).build();
    }

    public Query averagePutTimeQuery() {
        return this.queryBuilder.metric(Metric.CACHE_AVERAGE_PUT_TIME).build();
    }

    public Query averageRemoveTimeQuery() {
        return this.queryBuilder.metric(Metric.CACHE_AVERAGE_REMOVAL_TIME).build();
    }

    public Query lastAccessTimeQuery() {
        return this.queryBuilder.metric(Metric.CACHE_LAST_ACCESS_TIME).build();
    }

    public Query lastUpdateTimeQuery() {
        return this.queryBuilder.metric(Metric.CACHE_LAST_UPDATE_TIME).build();
    }

    public Query ownedEntryCountQuery() {
        return this.queryBuilder.metric(Metric.CACHE_OWNED_ENTRY_COUNT).build();
    }
}

