/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.aggregation;

import com.hazelcast.webmonitor.controller.dto.metrics.MetricDTO;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.MetricsStorage;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.aggregation.Aggregation;
import com.hazelcast.webmonitor.metrics.aggregation.Aggregator;
import com.hazelcast.webmonitor.metrics.aggregation.GroupByAggregator;
import java.util.List;
import java.util.Optional;

final class MemberBasedAggregation
implements Aggregation {
    private final MetricsStorage storage;
    private final List<String> members;
    private final String cluster;

    MemberBasedAggregation(MetricsStorage storage, List<String> members, String cluster) {
        this.storage = storage;
        this.members = members;
        this.cluster = cluster;
    }

    public DataPointSeries range(Query.Builder queryBuilder, MetricDTO.Aggregate aggregate) {
        this.ensureMembers();
        return this.aggregateRange(queryBuilder, aggregate);
    }

    public Optional<DataPointAware> latest(Query.Builder queryBuilder, MetricDTO.Aggregate aggregate) {
        this.ensureMembers();
        return this.aggregateRange(queryBuilder, aggregate).getLatestDataPoint();
    }

    private void ensureMembers() {
        if (this.members.isEmpty()) {
            throw new NoClusterApiException(this.cluster);
        }
    }

    private DataPointSeries aggregateRange(Query.Builder queryBuilder, MetricDTO.Aggregate aggregate) {
        GroupByAggregator aggregator = Aggregator.create((MetricDTO.Aggregate)aggregate);
        this.members.forEach(member -> aggregator.add(this.storage.queryRange(queryBuilder.member(member).build())));
        return aggregator.compute();
    }
}

