/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.validation.metrics;

import com.hazelcast.webmonitor.controller.dto.metrics.MetricDTO;
import com.hazelcast.webmonitor.controller.validation.metrics.ValidMetric;
import com.hazelcast.webmonitor.utils.StringUtil;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class MetricValidator
implements ConstraintValidator<ValidMetric, MetricDTO> {
    public void initialize(ValidMetric constraintAnnotation) {
    }

    public boolean isValid(MetricDTO dto, ConstraintValidatorContext constraintContext) {
        if (!this.supportedAggregateBy(dto)) {
            return false;
        }
        if (this.forMember(dto) && this.forClient(dto)) {
            return false;
        }
        if (!this.forMember(dto) && !this.forClient(dto)) {
            if (dto.getAggregate() == MetricDTO.Aggregate.DIFF_PER_SEC) {
                return false;
            }
            return dto.getAggregate() != null && dto.getAggregateBy() != null;
        }
        if (dto.getAggregate() == MetricDTO.Aggregate.DIFF_PER_SEC) {
            return dto.getAggregateBy() == null;
        }
        return dto.getAggregateBy() == null && dto.getAggregate() == null;
    }

    private boolean supportedAggregateBy(MetricDTO dto) {
        return dto.getAggregateBy() == null || dto.getAggregateBy() == MetricDTO.AggregateBy.MEMBERS;
    }

    private boolean forMember(MetricDTO dto) {
        return !StringUtil.isNullOrEmptyAfterTrim((String)dto.getMember());
    }

    private boolean forClient(MetricDTO dto) {
        return !StringUtil.isNullOrEmptyAfterTrim((String)dto.getClient());
    }
}

