/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.Util;
import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.jet.EdgeInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.ExportedJobSnapshotDTO;
import com.hazelcast.webmonitor.controller.dto.jet.JobInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.JobStatsDTO;
import com.hazelcast.webmonitor.controller.dto.jet.MinimizedJobInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.TaskCountsDTO;
import com.hazelcast.webmonitor.controller.dto.jet.VertexInfoDTO;
import com.hazelcast.webmonitor.controller.exception.NoResourceApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.jet.JetService;
import java.util.List;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class JetController
extends BaseInternalController {
    private final MCClientManager clientManager;
    private final JetService jetService;

    public JetController(StateManager stateManager, AuditLogService auditService, MCClientManager clientManager, JetService jetService) {
        super(stateManager, auditService);
        this.clientManager = clientManager;
        this.jetService = jetService;
    }

    @GetMapping(value={"/clusters/{cluster}/jobs"})
    public List<MinimizedJobInfoDTO> getJobs(@PathVariable String cluster) {
        return this.jetService.getJobs(cluster);
    }

    @GetMapping(value={"/clusters/{cluster}/jobs/{id}"})
    public JobInfoDTO getJob(@PathVariable String cluster, @PathVariable String id) {
        return this.jetService.getJobInfo(cluster, id);
    }

    @PostMapping(value={"/clusters/{cluster}/jobs/{id}/restart"})
    @Secured(value={"ROLE_ADMIN", "ROLE_CLOUD_USER"})
    public void restartJob(@PathVariable String cluster, @PathVariable String id) {
        Job job = this.getJobFromId(cluster, id);
        this.executeOperation(() -> ((Job)job).restart(), this.operationLogBuilder("MC-9001 [Streaming]", "Restart Job").parameter("cluster", (Object)cluster).parameter("jobId", (Object)id).parameter("jobName", (Object)job.getName()));
    }

    @PostMapping(value={"/clusters/{cluster}/jobs/{id}/suspend"})
    @Secured(value={"ROLE_ADMIN", "ROLE_CLOUD_USER"})
    public void suspendJob(@PathVariable String cluster, @PathVariable String id) {
        Job job = this.getJobFromId(cluster, id);
        this.executeOperation(() -> ((Job)job).suspend(), this.operationLogBuilder("MC-9002 [Streaming]", "Suspend Job").parameter("cluster", (Object)cluster).parameter("jobId", (Object)id).parameter("jobName", (Object)job.getName()));
    }

    @PostMapping(value={"/clusters/{cluster}/jobs/{id}/resume"})
    @Secured(value={"ROLE_ADMIN", "ROLE_CLOUD_USER"})
    public void resumeJob(@PathVariable String cluster, @PathVariable String id) {
        Job job = this.getJobFromId(cluster, id);
        this.executeOperation(() -> ((Job)job).resume(), this.operationLogBuilder("MC-9003 [Streaming]", "Resume Job").parameter("cluster", (Object)cluster).parameter("jobId", (Object)id).parameter("jobName", (Object)job.getName()));
    }

    @PostMapping(value={"/clusters/{cluster}/jobs/{id}/cancel"})
    @Secured(value={"ROLE_ADMIN", "ROLE_CLOUD_USER"})
    public void cancelJob(@PathVariable String cluster, @PathVariable String id) {
        Job job = this.getJobFromId(cluster, id);
        this.executeOperation(() -> ((Job)job).cancel(), this.operationLogBuilder("MC-9004 [Streaming]", "Cancel Job").parameter("cluster", (Object)cluster).parameter("jobId", (Object)id).parameter("jobName", (Object)job.getName()));
    }

    @GetMapping(value={"/clusters/{cluster}/jobs/{id}/{vertex}"})
    public VertexInfoDTO getVertexDetails(@PathVariable String cluster, @PathVariable String id, @PathVariable String vertex) {
        return this.jetService.getVertexDetails(cluster, id, vertex);
    }

    @GetMapping(value={"/clusters/{cluster}/jobs/{id}/{sourceVertex}/{fromOrdinal}/{targetVertex}/{toOrdinal}"})
    public EdgeInfoDTO getEdgeDetails(@PathVariable String cluster, @PathVariable String id, @PathVariable String sourceVertex, @PathVariable int fromOrdinal, @PathVariable String targetVertex, @PathVariable int toOrdinal) {
        return this.jetService.lookUpEdgeInfo(cluster, id, sourceVertex, fromOrdinal, targetVertex, toOrdinal);
    }

    @GetMapping(value={"/clusters/{cluster}/snapshots"})
    public List<ExportedJobSnapshotDTO> getSnapshots(@PathVariable String cluster) {
        return this.jetService.getExportedSnapshots(cluster);
    }

    @DeleteMapping(value={"/clusters/{cluster}/snapshots/{snapshotName}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_CLOUD_USER"})
    public void deleteSnapshot(@PathVariable String cluster, @PathVariable String snapshotName) {
        JobStateSnapshot snapshot = this.clientFor(cluster).getJobStateSnapshot(snapshotName);
        if (snapshot == null) {
            throw new NoResourceApiException("snapshot with name " + snapshotName);
        }
        this.executeOperation(() -> ((JobStateSnapshot)snapshot).destroy(), this.operationLogBuilder("MC-9005 [Streaming]", "Delete Snapshot").parameter("cluster", (Object)cluster).parameter("snapshotName", (Object)snapshotName));
    }

    @PostMapping(value={"/clusters/{cluster}/jobs/{id}/exportSnapshot/{snapshotName}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_CLOUD_USER"})
    public void exportSnapshot(@PathVariable String cluster, @PathVariable String id, @PathVariable String snapshotName) {
        Job job = this.getJobFromId(cluster, id);
        this.executeOperation(() -> job.exportSnapshot(snapshotName), this.operationLogBuilder("MC-9006 [Streaming]", "Export Snapshot").parameter("cluster", (Object)cluster).parameter("jobId", (Object)id).parameter("jobName", (Object)job.getName()).parameter("snapshotName", (Object)snapshotName));
    }

    @PostMapping(value={"/clusters/{cluster}/jobs/{id}/cancelAndExportSnapshot/{snapshotName}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_CLOUD_USER"})
    public void cancelAndExportSnapshot(@PathVariable String cluster, @PathVariable String id, @PathVariable String snapshotName) {
        Job job = this.getJobFromId(cluster, id);
        this.executeOperation(() -> job.cancelAndExportSnapshot(snapshotName), this.operationLogBuilder("MC-9007 [Streaming]", "Cancel and Export Snapshot").parameter("cluster", (Object)cluster).parameter("jobId", (Object)id).parameter("jobName", (Object)job.getName()).parameter("snapshotName", (Object)snapshotName));
    }

    @GetMapping(value={"/clusters/{cluster}/taskCounts"})
    public TaskCountsDTO getTaskCounts(@PathVariable String cluster) {
        return this.jetService.getTaskCounts(cluster);
    }

    @GetMapping(value={"/clusters/{cluster}/aggregateJobStats"})
    public JobStatsDTO getAggregateJobStats(@PathVariable String cluster, @RequestParam(defaultValue="0") long time) {
        return this.jetService.getAggregateJobStats(cluster, time);
    }

    private MCClient clientFor(String cluster) {
        return this.clientManager.clientFor(cluster);
    }

    private Job getJobFromId(String cluster, String id) {
        long jobId = Util.idFromString((String)id);
        return this.clientFor(cluster).getJobs().stream().filter(j -> j.getId() == jobId).findFirst().orElseThrow(() -> new NoResourceApiException("Job with id -> " + id));
    }
}

