/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.diagnosticconfig.DiagnosticsConfigResponseDTO;
import com.hazelcast.webmonitor.controller.dto.diagnosticconfig.UpdateDiagnosticsConfigRequestDTO;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.diagnosticsconfig.DiagnosticsConfigVersionAwareService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/clusters/{cluster}/diagnostics/config"})
public class DiagnosticsConfigController
extends BaseInternalController {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsConfigController.class);
    private final DiagnosticsConfigVersionAwareService diagnosticsConfigService;

    public DiagnosticsConfigController(DiagnosticsConfigVersionAwareService diagnosticsConfigService, StateManager stateManager, AuditLogService auditService) {
        super(stateManager, auditService);
        this.diagnosticsConfigService = diagnosticsConfigService;
    }

    @GetMapping
    public DiagnosticsConfigResponseDTO getDiagnosticsConfig(@PathVariable String cluster) {
        return this.diagnosticsConfigService.getDiagnosticsConfig(cluster);
    }

    @PostMapping
    @Secured(value={"ROLE_ADMIN"})
    public void setDiagnosticsConfig(@PathVariable String cluster, @NotNull @RequestBody UpdateDiagnosticsConfigRequestDTO updateRequest) {
        this.executeOperation(() -> this.diagnosticsConfigService.setDiagnosticsConfig(cluster, updateRequest), this.configLogBuilder("MC-1009 [Cluster Config]", "DiagnosticsConfig").parameter("isEnabled", (Object)updateRequest.isEnabled()).parameter("autoOffDurationInMinutes", (Object)updateRequest.getAutoOffDurationInMinutes()));
    }
}

