/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.external;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.AddWanReplicationDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanChangeStateDto;
import com.hazelcast.webmonitor.controller.dto.wan.WanConsistencyCheckDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanConsistencyCheckResultDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanEventsGroup;
import com.hazelcast.webmonitor.controller.dto.wan.WanMapDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanPublisherStatsDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanReplicationDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanSyncDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanSyncResultDTO;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.controller.internal.BaseWANController;
import com.hazelcast.webmonitor.events.WanEventService;
import com.hazelcast.webmonitor.service.AddWanConfigResultDTO;
import com.hazelcast.webmonitor.service.Licensed;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.WanReplicationManager;
import com.hazelcast.webmonitor.service.wan.WanReplicationConfigService;
import com.hazelcast.webmonitor.service.wan.WanReplicationStatsService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.validation.Valid;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest"})
@ConditionalOnProperty(name={"hazelcast.mc.rest.enabled"}, havingValue="true")
public class WANRestController
extends BaseWANController {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WANRestController.class);
    private final WanEventService wanEventService;

    @Autowired
    public WANRestController(StateManager stateManager, WanReplicationManager wanReplicationManager, WanReplicationStatsService wanStatsService, WanReplicationConfigService wanReplicationConfigService, AuditLogService auditService, WanEventService wanEventService) {
        super(stateManager, wanReplicationManager, wanStatsService, wanReplicationConfigService, auditService);
        this.wanEventService = wanEventService;
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @GetMapping(path={"/clusters/{cluster}/wan/replications"})
    public List<WanReplicationDTO> getWanReplications(@PathVariable String cluster) {
        return this.getWanReplicationsInternal(cluster, null, null);
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @GetMapping(path={"/clusters/{cluster}/wan/replications/{replication}"})
    public WanReplicationDTO getWanReplication(@PathVariable String cluster, @PathVariable String replication) {
        return this.getWanReplicationInternal(cluster, replication);
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @PostMapping(path={"/clusters/{cluster}/wan/replications"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public AddWanConfigResultDTO addWanReplication(@PathVariable String cluster, @Valid @RequestBody AddWanReplicationDTO addWanReplicationDTO, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        return this.addWanReplicationInternal(cluster, addWanReplicationDTO);
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @GetMapping(path={"/clusters/{cluster}/wan/replications/{replication}/publishers/{publisher}"})
    public WanPublisherStatsDTO getPublisher(@PathVariable String cluster, @PathVariable String replication, @PathVariable String publisher) {
        return this.getPublisherInternal(cluster, replication, publisher);
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @GetMapping(path={"/clusters/{cluster}/wan/replications/{replication}/maps"})
    public List<WanMapDTO> getMaps(@PathVariable String cluster, @PathVariable String replication) {
        return this.getMapsInternal(cluster, replication).stream().map(it -> new WanMapDTO(it.getName())).collect(Collectors.toList());
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @PostMapping(path={"/clusters/{cluster}/wan/consistencyChecks"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public WanConsistencyCheckResultDTO startWanConsistencyCheck(@PathVariable String cluster, @Valid @RequestBody WanConsistencyCheckDTO wanConsistencyCheckDTO, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        return this.startWanConsistencyCheckInternal(cluster, wanConsistencyCheckDTO.getReplication(), wanConsistencyCheckDTO.getPublisher(), wanConsistencyCheckDTO.getMap());
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @DeleteMapping(path={"/clusters/{cluster}/wan/replications/{replication}/publishers/{publisher}/queues"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void clearQueues(@PathVariable String cluster, @PathVariable String replication, @PathVariable String publisher) {
        this.clearQueuesInternal(cluster, replication, publisher, null);
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @DeleteMapping(path={"/clusters/{cluster}/wan/replications/{replication}/publishers/{publisher}/members/{member}/queues"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void clearQueues(@PathVariable String cluster, @PathVariable String replication, @PathVariable String publisher, @PathVariable String member) {
        this.clearQueuesInternal(cluster, replication, publisher, member);
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @PostMapping(path={"/clusters/{cluster}/wan/replications/{replication}/publishers/{publisher}/state"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void changeWanState(@PathVariable String cluster, @PathVariable String replication, @PathVariable String publisher, @Valid @RequestBody WanChangeStateDto wanChangeStateDto, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.changeWanStateInternal(cluster, replication, publisher, wanChangeStateDto.getState(), null);
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @PostMapping(path={"/clusters/{cluster}/wan/replications/{replication}/publishers/{publisher}/members/{member}/state"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void changeWanState(@PathVariable String cluster, @PathVariable String replication, @PathVariable String publisher, @PathVariable String member, @Valid @RequestBody WanChangeStateDto wanChangeStateDto, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.changeWanStateInternal(cluster, replication, publisher, wanChangeStateDto.getState(), member);
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @PostMapping(path={"/clusters/{cluster}/wan/syncs"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public WanSyncResultDTO startWanMapSync(@PathVariable String cluster, @Valid @RequestBody WanSyncDTO wanSyncDTO, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        return this.startWanMapSyncInternal(cluster, wanSyncDTO.getReplication(), wanSyncDTO.getPublisher(), wanSyncDTO.getMap());
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @GetMapping(path={"/clusters/{cluster}/wan/syncs"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public List<WanEventsGroup> getAllWanMapSyncs(@PathVariable String cluster) {
        return this.wanEventService.getGroupedWanSyncEvents(cluster).stream().filter(it -> it.getType() == WanEventsGroup.Type.SYNC).collect(Collectors.toList());
    }

    @Licensed(value={Feature.CLUSTERED_REST, Feature.WAN})
    @GetMapping(path={"/clusters/{cluster}/wan/syncs/{syncId}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public WanEventsGroup getWanMapSync(@PathVariable String cluster, @PathVariable String syncId) {
        return this.wanEventService.getGroupedWanSyncEvents(cluster).stream().filter(it -> syncId.equals(it.getUuid())).findFirst().orElse(null);
    }
}

