/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config.properties;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="hazelcast.mc.client")
public class MCClientConfigurationProperties {
    public static final int MC_CLIENT_DEFAULT_INITIAL_BACKOFF_MILLIS = 1000;
    public static final int MC_CLIENT_DEFAULT_BACKOFF_MULTIPLIER = 2;
    public static final int MC_CLIENT_DEFAULT_MAX_BACKOFF_MILLIS = 32000;
    @Min(value=1000L)
    @Max(value=60000L)
    @Value(value="${hazelcast.mc.client.initial.backoff.millis:1000}")
    private @Min(value=1000L) @Max(value=60000L) int initialBackoffMillis = 1000;
    @Min(value=1L)
    @Max(value=10L)
    @Value(value="${hazelcast.mc.client.backoff.multiplier:2}")
    private @Min(value=1L) @Max(value=10L) int backoffMultiplier = 2;
    @Min(value=32000L)
    @Max(value=600000L)
    @Value(value="${hazelcast.mc.client.max.backoff.millis:32000}")
    private @Min(value=32000L) @Max(value=600000L) int maxBackoffMillis = 32000;

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setInitialBackoffMillis(int initialBackoffMillis) {
        this.initialBackoffMillis = initialBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setBackoffMultiplier(int backoffMultiplier) {
        this.backoffMultiplier = backoffMultiplier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxBackoffMillis(int maxBackoffMillis) {
        this.maxBackoffMillis = maxBackoffMillis;
    }
}

