/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.hazelcast.webmonitor.controller.dto.AddClusterRequestDTO;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.repositories.sql.ClusterRepository;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.service.conndiagnosis.ConnDiagnosisService;
import com.hazelcast.webmonitor.service.conndiagnosis.ConnectionDiagnosis;
import com.hazelcast.webmonitor.service.conndiagnosis.DiagnosisStatus;
import com.hazelcast.webmonitor.utils.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!test & !hzcloud"})
public class DefaultClusterCreator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterCreator.class);
    private static final int DIAGNOSIS_WAIT_SECONDS = 3;
    private static final int SCHEDULE_PERIOD_SECONDS = 30;
    private static final String DEFAULT_DEV_CLUSTER_MEMBER = "localhost:5701";
    public static final String DEV_CLUSTER = "dev";
    private final ClusterRepository clusterRepository;
    private final AuthenticationManagerImpl authenticationManager;
    private final ConnDiagnosisService connDiagnosisService;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "DevClusterConnection"));
    ScheduledFuture<?> defaultClusterScheduledFuture;
    String defaultMember = "localhost:5701";
    @Value(value="#{environment.MC_DEFAULT_CLUSTER_MEMBERS}")
    String members;
    @Value(value="#{environment.MC_DEFAULT_CLUSTER}")
    String clusterName = "dev";

    @PostConstruct
    void createTargetCluster() {
        if (!StringUtil.isNullOrEmptyAfterTrim((String)this.members)) {
            List<String> membersList = List.of(this.members.split(","));
            if (this.clusterRepository.getAllClusterNames().contains(this.clusterName)) {
                this.failIfDifferentConfigs(membersList);
            } else {
                this.addClusterConnection(membersList);
                log.info("Created a '{}' cluster connection from MC_DEFAULT_CLUSTER and with members {} from MC_DEFAULT_CLUSTER_MEMBERS", (Object)this.clusterName, (Object)this.members);
            }
        } else {
            this.defaultClusterScheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(() -> this.connectDefaultClusterInDevMode(), 0L, 30L, TimeUnit.SECONDS);
        }
    }

    @VisibleForTesting
    void connectDefaultClusterInDevMode() {
        if (this.authenticationManager.isDevModeActive() && this.clusterRepository.getAllClusterNames().isEmpty()) {
            this.addClusterConnection(List.of(this.defaultMember));
            if (this.isClusterConnectionSuccessful()) {
                log.info("Created a default '{}' cluster connection in DEV mode with members {}", (Object)this.clusterName, (Object)this.defaultMember);
                this.defaultClusterScheduledFuture.cancel(false);
            } else {
                this.removeClusterConnection();
            }
        } else {
            this.defaultClusterScheduledFuture.cancel(false);
        }
    }

    private void failIfDifferentConfigs(List<String> members) {
        ClusterModel existingCluster = this.clusterRepository.getCluster(this.clusterName);
        Set<String> existingMembers = Set.of(existingCluster.getMemberAddresses());
        Set<String> membersSet = Set.copyOf(members);
        if (!Sets.symmetricDifference(membersSet, existingMembers).isEmpty()) {
            String errorMessage = String.format("Cluster %s exists with members %s, but MC_DEFAULT_CLUSTER_MEMBERS is %s", this.clusterName, String.join((CharSequence)",", existingMembers), String.join((CharSequence)",", membersSet));
            log.error(errorMessage);
            throw new Error(errorMessage);
        }
    }

    private boolean isClusterConnectionSuccessful() {
        this.connDiagnosisService.initiateDiagnosis(this.clusterName);
        TimeUnit.SECONDS.sleep(3L);
        ConnectionDiagnosis diagnosis = this.connDiagnosisService.getDiagnosis(this.clusterName);
        return diagnosis != null && diagnosis.getStatus() == DiagnosisStatus.SUCCESS;
    }

    private void removeClusterConnection() {
        this.clusterRepository.remove(this.clusterName);
    }

    private void addClusterConnection(List<String> memberList) {
        this.clusterRepository.add(new AddClusterRequestDTO(this.clusterName, memberList, true));
    }

    @ConstructorProperties(value={"clusterRepository", "authenticationManager", "connDiagnosisService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultClusterCreator(ClusterRepository clusterRepository, AuthenticationManagerImpl authenticationManager, ConnDiagnosisService connDiagnosisService) {
        this.clusterRepository = clusterRepository;
        this.authenticationManager = authenticationManager;
        this.connDiagnosisService = connDiagnosisService;
    }
}

