/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.SensitivePropertiesSettingTask;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.service.SettingsService;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Configures sensitive properties (ones to be hidden or masked) in MC Settings"})
class SensitivePropertiesSettingTask
extends BaseCliTask {
    @CommandLine.ArgGroup(multiplicity="1", exclusive=false)
    SensitivePropertiesArgGroup args;

    SensitivePropertiesSettingTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        SettingsService settingsService = new SettingsService(new SettingsDAO(this.initJdbi()));
        if (this.args.maskedConfigProperties != null) {
            settingsService.saveMaskedConfigProperties(this.propertiesToList(this.args.maskedConfigProperties));
            this.println("Updated setting masked-config-properties.");
        }
        if (this.args.hiddenProperties != null) {
            settingsService.saveHiddenProperties(this.propertiesToList(this.args.hiddenProperties));
            this.println("Updated setting hidden-properties.");
        }
    }

    private List<String> propertiesToList(Set<String> inputProperties) {
        return inputProperties.stream().filter(prop -> !prop.isEmpty()).collect(Collectors.toList());
    }
}

