/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web.entryprocessor;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.web.SessionState;
import com.hazelcast.web.WebDataSerializerHook;
import java.io.IOException;
import java.util.Map;

public final class DeleteSessionEntryProcessor
implements EntryProcessor<String, SessionState, Object>,
IdentifiedDataSerializable {
    private boolean invalidate;
    private boolean removed;

    public DeleteSessionEntryProcessor(boolean invalidate) {
        this.invalidate = invalidate;
    }

    public DeleteSessionEntryProcessor() {
    }

    public int getFactoryId() {
        return WebDataSerializerHook.F_ID;
    }

    public int getClassId() {
        return 2;
    }

    public Object process(Map.Entry<String, SessionState> entry) {
        SessionState sessionState = entry.getValue();
        if (sessionState == null) {
            return Boolean.FALSE;
        }
        if (this.invalidate) {
            entry.setValue(null);
            this.removed = true;
        } else {
            entry.setValue(sessionState);
        }
        return Boolean.TRUE;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.invalidate);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.invalidate = in.readBoolean();
    }
}

