/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.rest.entities.LoggerLevel;
import org.apache.kafka.connect.runtime.rest.errors.BadRequestException;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin/loggers")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LoggingResource {
    private static final Logger log = LoggerFactory.getLogger(LoggingResource.class);
    private static final String WORKER_SCOPE = "worker";
    private static final String CLUSTER_SCOPE = "cluster";
    private final Herder herder;

    @Inject
    public LoggingResource(Herder herder) {
        this.herder = herder;
    }

    @GET
    @Operation(summary="List the current loggers that have their levels explicitly set and their log levels")
    public Response listLoggers() {
        return Response.ok(this.herder.allLoggerLevels()).build();
    }

    @GET
    @Path(value="/{logger}")
    @Operation(summary="Get the log level for the specified logger")
    public Response getLogger(@PathParam(value="logger") String namedLogger) {
        Objects.requireNonNull(namedLogger, "require non-null name");
        LoggerLevel loggerLevel = this.herder.loggerLevel(namedLogger);
        if (loggerLevel == null) {
            throw new NotFoundException("Logger " + namedLogger + " not found.");
        }
        return Response.ok(loggerLevel).build();
    }

    @PUT
    @Path(value="/{logger}")
    @Operation(summary="Set the log level for the specified logger")
    public Response setLevel(@PathParam(value="logger") String namespace, Map<String, String> levelMap, @DefaultValue(value="worker") @QueryParam(value="scope") @Parameter(description="The scope for the logging modification (single-worker, cluster-wide, etc.)") String scope) {
        String levelString;
        if (scope == null) {
            log.warn("Received null scope in request to adjust logging level; will default to {}", (Object)WORKER_SCOPE);
            scope = WORKER_SCOPE;
        }
        if ((levelString = levelMap.get("level")) == null) {
            throw new BadRequestException("Desired 'level' parameter was not specified in request.");
        }
        Level level = Level.toLevel(levelString.toUpperCase(Locale.ROOT), null);
        if (level == null) {
            throw new NotFoundException("invalid log level '" + levelString + "'.");
        }
        switch (scope.toLowerCase(Locale.ROOT)) {
            default: {
                log.warn("Received invalid scope '{}' in request to adjust logging level; will default to {}", (Object)scope, (Object)WORKER_SCOPE);
            }
            case "worker": {
                List<String> affectedLoggers = this.herder.setWorkerLoggerLevel(namespace, levelString);
                return Response.ok(affectedLoggers).build();
            }
            case "cluster": 
        }
        this.herder.setClusterLoggerLevel(namespace, levelString);
        return Response.noContent().build();
    }
}

