/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.json;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.hazelcast.shaded.com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class JsonSerializer
implements Serializer<JsonNode> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonSerializer() {
        this(Collections.emptySet(), new JsonNodeFactory(true), true);
    }

    JsonSerializer(Set<SerializationFeature> serializationFeatures, JsonNodeFactory jsonNodeFactory, boolean enableAfterburner) {
        serializationFeatures.forEach(this.objectMapper::enable);
        this.objectMapper.setNodeFactory(jsonNodeFactory);
        if (enableAfterburner) {
            this.objectMapper.registerModule(new AfterburnerModule());
        }
    }

    @Override
    public byte[] serialize(String topic, JsonNode data) {
        if (data == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes(data);
        }
        catch (Exception e) {
            throw new SerializationException("Error serializing JSON message", e);
        }
    }
}

