/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.file.FileStreamSinkConnector;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStreamSinkTask
extends SinkTask {
    private static final Logger log = LoggerFactory.getLogger(FileStreamSinkTask.class);
    private String filename;
    private PrintStream outputStream;

    public FileStreamSinkTask() {
    }

    public FileStreamSinkTask(PrintStream outputStream) {
        this.filename = null;
        this.outputStream = outputStream;
    }

    @Override
    public String version() {
        return new FileStreamSinkConnector().version();
    }

    @Override
    public void start(Map<String, String> props) {
        AbstractConfig config = new AbstractConfig(FileStreamSinkConnector.CONFIG_DEF, props);
        this.filename = config.getString("file");
        if (this.filename == null || this.filename.isEmpty()) {
            this.outputStream = System.out;
        } else {
            try {
                this.outputStream = new PrintStream(Files.newOutputStream(Paths.get(this.filename, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.APPEND), false, StandardCharsets.UTF_8.name());
            }
            catch (IOException e) {
                throw new ConnectException("Couldn't find or create file '" + this.filename + "' for FileStreamSinkTask", e);
            }
        }
    }

    @Override
    public void put(Collection<SinkRecord> sinkRecords) {
        for (SinkRecord record : sinkRecords) {
            log.trace("Writing line to {}: {}", (Object)this.logFilename(), record.value());
            this.outputStream.println(record.value());
        }
    }

    @Override
    public void flush(Map<TopicPartition, OffsetAndMetadata> offsets) {
        log.trace("Flushing output stream for {}", (Object)this.logFilename());
        this.outputStream.flush();
    }

    @Override
    public void stop() {
        if (this.outputStream != null && this.outputStream != System.out) {
            this.outputStream.close();
        }
    }

    private String logFilename() {
        return this.filename == null ? "stdout" : this.filename;
    }
}

