/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.utils.Utils;

public final class MessageUtil {
    public static final long UNSIGNED_INT_MAX = 0xFFFFFFFFL;
    public static final int UNSIGNED_SHORT_MAX = 65535;

    public static byte[] byteBufferToArray(ByteBuffer buf) {
        byte[] arr = new byte[buf.remaining()];
        int prevPosition = buf.position();
        try {
            buf.get(arr);
        }
        finally {
            buf.position(prevPosition);
        }
        return arr;
    }

    public static String deepToString(Iterator<?> iter) {
        StringBuilder bld = new StringBuilder("[");
        String prefix = "";
        while (iter.hasNext()) {
            Object object = iter.next();
            bld.append(prefix);
            bld.append(object.toString());
            prefix = ", ";
        }
        bld.append("]");
        return bld.toString();
    }

    public static byte jsonNodeToByte(JsonNode node, String about) {
        int value = MessageUtil.jsonNodeToInt(node, about);
        if (value > 127) {
            if (value <= 256) {
                value -= 128;
            } else {
                throw new RuntimeException(about + ": value " + value + " does not fit in an 8-bit signed integer.");
            }
        }
        if (value < -128) {
            throw new RuntimeException(about + ": value " + value + " does not fit in an 8-bit signed integer.");
        }
        return (byte)value;
    }

    public static short jsonNodeToShort(JsonNode node, String about) {
        int value = MessageUtil.jsonNodeToInt(node, about);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new RuntimeException(about + ": value " + value + " does not fit in a 16-bit signed integer.");
        }
        return (short)value;
    }

    public static int jsonNodeToUnsignedShort(JsonNode node, String about) {
        int value = MessageUtil.jsonNodeToInt(node, about);
        if (value < 0 || value > 65535) {
            throw new RuntimeException(about + ": value " + value + " does not fit in a 16-bit unsigned integer.");
        }
        return value;
    }

    public static long jsonNodeToUnsignedInt(JsonNode node, String about) {
        long value = MessageUtil.jsonNodeToLong(node, about);
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new RuntimeException(about + ": value " + value + " does not fit in a 32-bit unsigned integer.");
        }
        return value;
    }

    public static int jsonNodeToInt(JsonNode node, String about) {
        if (node.isInt()) {
            return node.asInt();
        }
        if (node.isTextual()) {
            throw new NumberFormatException(about + ": expected an integer or string type, but got " + (Object)((Object)node.getNodeType()));
        }
        String text = node.asText();
        if (text.startsWith("0x")) {
            try {
                return Integer.parseInt(text.substring(2), 16);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(about + ": failed to parse hexadecimal number: " + e.getMessage());
            }
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(about + ": failed to parse number: " + e.getMessage());
        }
    }

    public static long jsonNodeToLong(JsonNode node, String about) {
        if (node.isLong()) {
            return node.asLong();
        }
        if (node.isTextual()) {
            throw new NumberFormatException(about + ": expected an integer or string type, but got " + (Object)((Object)node.getNodeType()));
        }
        String text = node.asText();
        if (text.startsWith("0x")) {
            try {
                return Long.parseLong(text.substring(2), 16);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(about + ": failed to parse hexadecimal number: " + e.getMessage());
            }
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(about + ": failed to parse number: " + e.getMessage());
        }
    }

    public static byte[] jsonNodeToBinary(JsonNode node, String about) {
        try {
            byte[] value = node.binaryValue();
            if (value == null) {
                throw new IllegalArgumentException(about + ": expected Base64-encoded binary data.");
            }
            return value;
        }
        catch (IOException e) {
            throw new UncheckedIOException(about + ": unable to retrieve Base64-encoded binary data", e);
        }
    }

    public static double jsonNodeToDouble(JsonNode node, String about) {
        if (!node.isFloatingPointNumber()) {
            throw new NumberFormatException(about + ": expected a floating point type, but got " + (Object)((Object)node.getNodeType()));
        }
        return node.asDouble();
    }

    public static byte[] duplicate(byte[] array) {
        if (array == null) {
            return null;
        }
        return Arrays.copyOf(array, array.length);
    }

    public static boolean compareRawTaggedFields(List<RawTaggedField> first, List<RawTaggedField> second) {
        if (first == null) {
            return second == null || second.isEmpty();
        }
        if (second == null) {
            return first.isEmpty();
        }
        return first.equals(second);
    }

    public static ByteBuffer toByteBuffer(Message message, short version) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int messageSize = message.size(cache, version);
        ByteBufferAccessor bytes = new ByteBufferAccessor(ByteBuffer.allocate(messageSize));
        message.write(bytes, cache, version);
        bytes.flip();
        return bytes.buffer();
    }

    public static ByteBuffer toVersionPrefixedByteBuffer(short version, Message message) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int messageSize = message.size(cache, version);
        ByteBufferAccessor bytes = new ByteBufferAccessor(ByteBuffer.allocate(messageSize + 2));
        bytes.writeShort(version);
        message.write(bytes, cache, version);
        bytes.flip();
        return bytes.buffer();
    }

    public static byte[] toVersionPrefixedBytes(short version, Message message) {
        ByteBuffer buffer = MessageUtil.toVersionPrefixedByteBuffer(version, message);
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.position() == 0 && buffer.limit() == buffer.array().length) {
            return buffer.array();
        }
        return Utils.toArray(buffer);
    }
}

