/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.IntNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.ShortNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.protocol.MessageUtil;

public class LeaderChangeMessageJsonConverter {
    public static LeaderChangeMessage read(JsonNode _node, short _version) {
        LeaderChangeMessage _object = new LeaderChangeMessage();
        JsonNode _versionNode = _node.get("version");
        if (_versionNode == null) {
            throw new RuntimeException("LeaderChangeMessage: unable to locate field 'version', which is mandatory in version " + _version);
        }
        _object.version = MessageUtil.jsonNodeToShort(_versionNode, "LeaderChangeMessage");
        JsonNode _leaderIdNode = _node.get("leaderId");
        if (_leaderIdNode == null) {
            throw new RuntimeException("LeaderChangeMessage: unable to locate field 'leaderId', which is mandatory in version " + _version);
        }
        _object.leaderId = MessageUtil.jsonNodeToInt(_leaderIdNode, "LeaderChangeMessage");
        JsonNode _votersNode = _node.get("voters");
        if (_votersNode == null) {
            throw new RuntimeException("LeaderChangeMessage: unable to locate field 'voters', which is mandatory in version " + _version);
        }
        if (!_votersNode.isArray()) {
            throw new RuntimeException("LeaderChangeMessage expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        ArrayList<LeaderChangeMessage.Voter> _collection = new ArrayList<LeaderChangeMessage.Voter>(_votersNode.size());
        _object.voters = _collection;
        for (JsonNode _element : _votersNode) {
            _collection.add(VoterJsonConverter.read(_element, _version));
        }
        JsonNode _grantingVotersNode = _node.get("grantingVoters");
        if (_grantingVotersNode == null) {
            throw new RuntimeException("LeaderChangeMessage: unable to locate field 'grantingVoters', which is mandatory in version " + _version);
        }
        if (!_grantingVotersNode.isArray()) {
            throw new RuntimeException("LeaderChangeMessage expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        ArrayList<LeaderChangeMessage.Voter> _collection2 = new ArrayList<LeaderChangeMessage.Voter>(_grantingVotersNode.size());
        _object.grantingVoters = _collection2;
        for (JsonNode _element : _grantingVotersNode) {
            _collection2.add(VoterJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(LeaderChangeMessage _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("version", new ShortNode(_object.version));
        _node.set("leaderId", new IntNode(_object.leaderId));
        ArrayNode _votersArray = new ArrayNode(JsonNodeFactory.instance);
        for (LeaderChangeMessage.Voter _element : _object.voters) {
            _votersArray.add(VoterJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("voters", _votersArray);
        ArrayNode _grantingVotersArray = new ArrayNode(JsonNodeFactory.instance);
        for (LeaderChangeMessage.Voter _element : _object.grantingVoters) {
            _grantingVotersArray.add(VoterJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("grantingVoters", _grantingVotersArray);
        return _node;
    }

    public static JsonNode write(LeaderChangeMessage _object, short _version) {
        return LeaderChangeMessageJsonConverter.write(_object, _version, true);
    }

    public static class VoterJsonConverter {
        public static LeaderChangeMessage.Voter read(JsonNode _node, short _version) {
            LeaderChangeMessage.Voter _object = new LeaderChangeMessage.Voter();
            JsonNode _voterIdNode = _node.get("voterId");
            if (_voterIdNode == null) {
                throw new RuntimeException("Voter: unable to locate field 'voterId', which is mandatory in version " + _version);
            }
            _object.voterId = MessageUtil.jsonNodeToInt(_voterIdNode, "Voter");
            JsonNode _voterDirectoryIdNode = _node.get("voterDirectoryId");
            if (_voterDirectoryIdNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("Voter: unable to locate field 'voterDirectoryId', which is mandatory in version " + _version);
                }
                _object.voterDirectoryId = Uuid.ZERO_UUID;
            } else {
                if (!_voterDirectoryIdNode.isTextual()) {
                    throw new RuntimeException("Voter expected a JSON string type, but got " + (Object)((Object)_node.getNodeType()));
                }
                _object.voterDirectoryId = Uuid.fromString(_voterDirectoryIdNode.asText());
            }
            return _object;
        }

        public static JsonNode write(LeaderChangeMessage.Voter _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("voterId", new IntNode(_object.voterId));
            if (_version >= 1) {
                _node.set("voterDirectoryId", new TextNode(_object.voterDirectoryId.toString()));
            } else if (!_object.voterDirectoryId.equals(Uuid.ZERO_UUID)) {
                throw new UnsupportedVersionException("Attempted to write a non-default voterDirectoryId at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(LeaderChangeMessage.Voter _object, short _version) {
            return VoterJsonConverter.write(_object, _version, true);
        }
    }
}

