/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.outbox;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.data.Envelope;
import io.debezium.schema.FieldNameSelector;
import io.debezium.transforms.ConnectRecordUtil;
import io.debezium.transforms.SmtManager;
import io.debezium.transforms.outbox.EventRouterConfigDefinition;
import io.debezium.transforms.outbox.EventRouterConfigurationProvider;
import io.debezium.transforms.outbox.JsonSchemaData;
import io.debezium.transforms.tracing.ActivateTracingSpan;
import io.debezium.util.BoundedConcurrentHashMap;
import io.debezium.util.Loggings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.RegexRouter;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRouterDelegate<R extends ConnectRecord<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventRouterDelegate.class);
    private static final String ENVELOPE_PAYLOAD = "payload";
    private ExtractField<R> afterExtractor;
    private final RegexRouter<R> regexRouter = new RegexRouter();
    private EventRouterConfigDefinition.InvalidOperationBehavior invalidOperationBehavior;
    private final ActivateTracingSpan<R> tracingSmt = new ActivateTracingSpan();
    private final Map<String, EventRouterConfigurationProvider> configurationProviders = new HashMap<String, EventRouterConfigurationProvider>();
    private final DefaultConfigurationProvider defaultConfigurationProvider = new DefaultConfigurationProvider();
    private String fieldSchemaVersion;
    private boolean routeTombstoneOnEmptyPayload;
    private List<EventRouterConfigDefinition.AdditionalField> additionalFields;
    private boolean additionalFieldsErrorOnMissing;
    private final Map<Integer, Schema> versionedValueSchema = new HashMap<Integer, Schema>();
    private BoundedConcurrentHashMap<Schema, Schema> payloadSchemaCache;
    private boolean onlyHeadersInOutputMessage = false;
    private boolean expandJsonPayload;
    private JsonSchemaData jsonSchemaData;
    private ObjectMapper objectMapper;
    private SmtManager<R> smtManager;

    public R apply(R r, RecordConverter<R> recordConverter) {
        Schema updatedSchema;
        Object updatedValue;
        boolean isDeleteEvent;
        if (((ConnectRecord)r).value() == null) {
            LOGGER.debug("Tombstone message ignored. Message key: \"{}\"", Loggings.maybeRedactSensitiveData(((ConnectRecord)r).key()));
            return null;
        }
        if (!this.smtManager.isValidEnvelope(r)) {
            return (R)r;
        }
        Struct debeziumEventValue = Requirements.requireStruct(((ConnectRecord)r).value(), "Detect Debezium Operation");
        String op = debeziumEventValue.getString("op");
        if (op.equals(Envelope.Operation.DELETE.code())) {
            LOGGER.debug("Delete message {} ignored", Loggings.maybeRedactSensitiveData(((ConnectRecord)r).key()));
            return null;
        }
        if (op.equals(Envelope.Operation.UPDATE.code())) {
            this.handleUnexpectedOperation(r);
            return null;
        }
        r = (ConnectRecord)recordConverter.convert(r);
        if (ActivateTracingSpan.isOpenTelemetryAvailable()) {
            this.tracingSmt.apply(r);
        }
        R afterRecord = this.afterExtractor.apply(r);
        Struct eventStruct = Requirements.requireStruct(((ConnectRecord)afterRecord).value(), "Read Outbox Event");
        Schema eventValueSchema = ((ConnectRecord)afterRecord).valueSchema();
        Struct record = Requirements.requireStruct(((ConnectRecord)r).value(), "Outbox converter");
        EventRouterConfigurationProvider configProvider = this.lookupConfigurationProvider(record);
        String fieldEventId = configProvider.getFieldEventId();
        String fieldEventKey = configProvider.getFieldEventKey();
        String fieldPayload = configProvider.getFieldPayload();
        String fieldEventTimestamp = configProvider.getFieldEventTimestamp();
        String routeByField = configProvider.getRouteByField();
        Field payloadField = eventValueSchema.field(fieldPayload);
        if (payloadField == null) {
            throw new ConnectException(String.format("Unable to find payload field %s in event", fieldPayload));
        }
        Schema payloadSchema = payloadField.schema();
        Long timestamp = this.getEventTimestampMs(fieldEventTimestamp, debeziumEventValue, eventStruct);
        Object eventId = eventStruct.get(fieldEventId);
        Object payload = eventStruct.get(fieldPayload);
        Field eventIdField = eventValueSchema.field(fieldEventId);
        if (eventIdField == null) {
            throw new ConnectException(String.format("Unable to find event-id field %s in event", fieldEventId));
        }
        Headers headers = ((ConnectRecord)r).headers();
        headers.add("id", eventId, eventIdField.schema());
        if (this.expandJsonPayload) {
            if (!(payload instanceof String)) {
                LOGGER.warn("Expand JSON payload is turned on but payload is not a string in {}", Loggings.maybeRedactSensitiveData(((ConnectRecord)r).key()));
            } else {
                String payloadString = (String)payload;
                try {
                    JsonNode jsonPayload = this.parseJsonPayload(payloadString);
                    payloadSchema = this.jsonSchemaData.toConnectSchema(fieldPayload, jsonPayload);
                    payload = this.jsonSchemaData.toConnectData(jsonPayload, payloadSchema);
                }
                catch (Exception e) {
                    LOGGER.warn("JSON expansion failed", e);
                }
            }
        }
        Schema structValueSchema = this.onlyHeadersInOutputMessage ? null : (this.fieldSchemaVersion == null ? this.getValueSchema(payloadSchema, eventValueSchema, eventStruct.getString(routeByField)) : this.getValueSchema(payloadSchema, eventValueSchema, eventStruct.getInt32(this.fieldSchemaVersion), eventStruct.getString(routeByField)));
        Struct structValue = this.onlyHeadersInOutputMessage ? null : new Struct(structValueSchema).put(ENVELOPE_PAYLOAD, payload);
        AtomicReference partition = new AtomicReference();
        this.additionalFields.forEach(additionalField -> {
            if (!this.additionalFieldsErrorOnMissing && eventStruct.schema().field(additionalField.getField()) == null) {
                return;
            }
            switch (additionalField.getPlacement()) {
                case ENVELOPE: {
                    structValue.put(additionalField.getAlias(), eventStruct.get(additionalField.getField()));
                    break;
                }
                case HEADER: {
                    headers.add(additionalField.getAlias(), eventStruct.get(additionalField.getField()), eventValueSchema.field(additionalField.getField()).schema());
                    break;
                }
                case PARTITION: {
                    partition.set(eventStruct.getInt32(additionalField.getField()));
                }
            }
        });
        boolean bl = isDeleteEvent = payload == null || payload.toString().trim().isEmpty();
        if (isDeleteEvent && this.routeTombstoneOnEmptyPayload) {
            updatedValue = null;
            updatedSchema = null;
        } else if (this.onlyHeadersInOutputMessage) {
            updatedValue = payload;
            updatedSchema = payloadSchema;
        } else {
            updatedValue = structValue;
            updatedSchema = structValueSchema;
        }
        Object recordKey = this.defineRecordKey(fieldEventKey, eventStruct);
        Object newRecord = ((ConnectRecord)r).newRecord(eventStruct.getString(routeByField), (Integer)partition.get(), this.defineRecordKeySchema(fieldEventKey, eventValueSchema), recordKey, updatedSchema, updatedValue, timestamp, headers);
        LOGGER.debug("Message emitted with event id: \"{}\", event key: \"{}\"", eventId, Loggings.maybeRedactSensitiveData(recordKey));
        return this.regexRouter.apply(newRecord);
    }

    private Long getEventTimestampMs(String fieldEventTimestamp, Struct debeziumEventValue, Struct eventStruct) {
        if (fieldEventTimestamp == null) {
            return debeziumEventValue.getInt64("ts_ms");
        }
        Field timestampField = eventStruct.schema().field(fieldEventTimestamp);
        if (timestampField == null) {
            throw new ConnectException(String.format("Unable to find timestamp field %s in event", fieldEventTimestamp));
        }
        Long timestamp = eventStruct.getInt64(fieldEventTimestamp);
        if (timestamp == null) {
            return debeziumEventValue.getInt64("ts_ms");
        }
        String schemaName = timestampField.schema().name();
        if (schemaName == null) {
            throw new ConnectException(String.format("Unsupported field type %s (without logical schema name) for event timestamp", new Object[]{timestampField.schema().type()}));
        }
        switch (schemaName) {
            case "io.debezium.time.Timestamp": {
                return timestamp;
            }
            case "io.debezium.time.MicroTimestamp": {
                return timestamp / 1000L;
            }
            case "io.debezium.time.NanoTimestamp": {
                return timestamp / 1000000L;
            }
        }
        throw new ConnectException(String.format("Unsupported field type %s for event timestamp", schemaName));
    }

    private Schema defineRecordKeySchema(String fieldEventKey, Schema eventStruct) {
        Field eventKeySchema = null;
        if (fieldEventKey != null) {
            eventKeySchema = eventStruct.field(fieldEventKey);
        }
        if (eventKeySchema != null) {
            return eventKeySchema.schema();
        }
        return Schema.STRING_SCHEMA;
    }

    private Object defineRecordKey(String fieldEventKey, Struct eventStruct) {
        return fieldEventKey != null ? eventStruct.get(fieldEventKey) : null;
    }

    private void handleUnexpectedOperation(R r) {
        switch (this.invalidOperationBehavior) {
            case SKIP_AND_WARN: {
                LOGGER.warn("Unexpected update message received {} and ignored", Loggings.maybeRedactSensitiveData(((ConnectRecord)r).key()));
                break;
            }
            case SKIP_AND_ERROR: {
                LOGGER.error("Unexpected update message received {} and ignored", Loggings.maybeRedactSensitiveData(((ConnectRecord)r).key()));
                break;
            }
            case FATAL: {
                throw new IllegalStateException(String.format("Unexpected update message received %s, fail.", ((ConnectRecord)r).key()));
            }
        }
    }

    private JsonNode parseJsonPayload(String jsonString) throws Exception {
        if (jsonString.startsWith("{") || jsonString.startsWith("[")) {
            return this.objectMapper.readTree(jsonString);
        }
        throw new Exception("Unable to parse payload starting with '" + jsonString.charAt(0) + "'");
    }

    public ConfigDef config() {
        return EventRouterConfigDefinition.configDef();
    }

    public void close() {
        if (ActivateTracingSpan.isOpenTelemetryAvailable()) {
            this.tracingSmt.close();
        }
    }

    public void configure(Map<String, ?> configMap) {
        if (ActivateTracingSpan.isOpenTelemetryAvailable()) {
            this.tracingSmt.configure(configMap);
            if (!configMap.containsKey(ActivateTracingSpan.TRACING_CONTEXT_FIELD_REQUIRED.name())) {
                this.tracingSmt.setRequireContextField(true);
            }
        }
        Configuration config = Configuration.from(configMap);
        this.smtManager = new SmtManager(config);
        Field.Set allFields = io.debezium.config.Field.setOf(EventRouterConfigDefinition.CONFIG_FIELDS);
        this.smtManager.validate(config, allFields);
        this.invalidOperationBehavior = EventRouterConfigDefinition.InvalidOperationBehavior.parse(config.getString(EventRouterConfigDefinition.OPERATION_INVALID_BEHAVIOR));
        EventRouterConfigDefinition.JsonPayloadNullFieldBehavior jsonPayloadNullFieldBehavior = EventRouterConfigDefinition.JsonPayloadNullFieldBehavior.parse(config.getString(EventRouterConfigDefinition.TABLE_JSON_PAYLOAD_NULL_BEHAVIOR));
        this.expandJsonPayload = config.getBoolean(EventRouterConfigDefinition.EXPAND_JSON_PAYLOAD);
        if (this.expandJsonPayload) {
            this.objectMapper = new ObjectMapper();
            CommonConnectorConfig.FieldNameAdjustmentMode fieldNameAdjustmentMode = CommonConnectorConfig.FieldNameAdjustmentMode.parse(config.getString(CommonConnectorConfig.FIELD_NAME_ADJUSTMENT_MODE));
            this.jsonSchemaData = new JsonSchemaData(jsonPayloadNullFieldBehavior, FieldNameSelector.defaultNonRelationalSelector(fieldNameAdjustmentMode.createAdjuster()));
        }
        this.defaultConfigurationProvider.configure(configMap);
        for (EventRouterConfigurationProvider provider : ServiceLoader.load(EventRouterConfigurationProvider.class)) {
            this.configurationProviders.put(provider.getName(), provider);
            provider.configure(configMap);
        }
        this.fieldSchemaVersion = config.getString(EventRouterConfigDefinition.FIELD_SCHEMA_VERSION);
        this.routeTombstoneOnEmptyPayload = config.getBoolean(EventRouterConfigDefinition.ROUTE_TOMBSTONE_ON_EMPTY_PAYLOAD);
        HashMap<String, String> regexRouterConfig = new HashMap<String, String>();
        regexRouterConfig.put("regex", config.getString(EventRouterConfigDefinition.ROUTE_TOPIC_REGEX));
        regexRouterConfig.put("replacement", config.getString(EventRouterConfigDefinition.ROUTE_TOPIC_REPLACEMENT));
        this.regexRouter.configure(regexRouterConfig);
        this.afterExtractor = ConnectRecordUtil.extractAfterDelegate();
        this.additionalFields = EventRouterConfigDefinition.parseAdditionalFieldsConfig(config);
        this.additionalFieldsErrorOnMissing = config.getBoolean(EventRouterConfigDefinition.FIELDS_ADDITIONAL_ERROR_ON_MISSING);
        this.onlyHeadersInOutputMessage = this.additionalFields.stream().noneMatch(field -> field.getPlacement() == EventRouterConfigDefinition.AdditionalFieldPlacement.ENVELOPE);
        this.payloadSchemaCache = new BoundedConcurrentHashMap(10000, 10, BoundedConcurrentHashMap.Eviction.LRU);
    }

    private Schema getValueSchema(Schema payloadSchema, Schema debeziumEventSchema, String routedTopic) {
        Schema valueSchema = this.payloadSchemaCache.get(payloadSchema);
        if (valueSchema == null) {
            valueSchema = this.getSchemaBuilder(payloadSchema, debeziumEventSchema, routedTopic).build();
            this.payloadSchemaCache.put(payloadSchema, valueSchema);
        }
        return valueSchema;
    }

    private Schema getValueSchema(Schema payloadSchema, Schema debeziumEventSchema, Integer version, String routedTopic) {
        if (!this.versionedValueSchema.containsKey(version)) {
            Schema schema = this.getSchemaBuilder(payloadSchema, debeziumEventSchema, routedTopic).version(version).build();
            this.versionedValueSchema.put(version, schema);
        }
        return this.versionedValueSchema.get(version);
    }

    private SchemaBuilder getSchemaBuilder(Schema payloadSchema, Schema debeziumEventSchema, String routedTopic) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(this.getSchemaName(debeziumEventSchema, routedTopic));
        schemaBuilder.field(ENVELOPE_PAYLOAD, payloadSchema);
        this.additionalFields.forEach(additionalField -> {
            if (additionalField.getPlacement() == EventRouterConfigDefinition.AdditionalFieldPlacement.ENVELOPE) {
                schemaBuilder.field(additionalField.getAlias(), debeziumEventSchema.field(additionalField.getField()).schema());
            }
        });
        return schemaBuilder;
    }

    private String getSchemaName(Schema debeziumEventSchema, String routedTopic) {
        int lastDot;
        String originalSchemaName = debeziumEventSchema.name();
        Object schemaName = originalSchemaName != null ? ((lastDot = originalSchemaName.lastIndexOf(46)) != -1 ? originalSchemaName.substring(0, lastDot + 1) + routedTopic + "." + originalSchemaName.substring(lastDot + 1) : routedTopic + "." + originalSchemaName) : routedTopic;
        return schemaName;
    }

    private EventRouterConfigurationProvider lookupConfigurationProvider(Struct record) {
        Struct source;
        String connectorType;
        EventRouterConfigurationProvider provider;
        if (!this.configurationProviders.isEmpty() && (provider = this.configurationProviders.get(connectorType = (source = record.getStruct("source")).getString("connector"))) != null) {
            return provider;
        }
        return this.defaultConfigurationProvider;
    }

    private static class DefaultConfigurationProvider
    implements EventRouterConfigurationProvider {
        private String fieldEventId;
        private String fieldEventKey;
        private String fieldEventTimestamp;
        private String fieldPayload;
        private String routeByField;

        private DefaultConfigurationProvider() {
        }

        @Override
        public String getName() {
            return "default";
        }

        @Override
        public void configure(Map<String, ?> configMap) {
            Configuration config = Configuration.from(configMap);
            this.fieldEventId = config.getString(EventRouterConfigDefinition.FIELD_EVENT_ID);
            this.fieldEventKey = config.getString(EventRouterConfigDefinition.FIELD_EVENT_KEY);
            this.fieldEventTimestamp = config.getString(EventRouterConfigDefinition.FIELD_EVENT_TIMESTAMP);
            this.fieldPayload = config.getString(EventRouterConfigDefinition.FIELD_PAYLOAD);
            this.routeByField = config.getString(EventRouterConfigDefinition.ROUTE_BY_FIELD);
        }

        @Override
        public String getFieldEventId() {
            return this.fieldEventId;
        }

        @Override
        public String getFieldEventKey() {
            return this.fieldEventKey;
        }

        @Override
        public String getFieldEventTimestamp() {
            return this.fieldEventTimestamp;
        }

        @Override
        public String getFieldPayload() {
            return this.fieldPayload;
        }

        @Override
        public String getRouteByField() {
            return this.routeByField;
        }
    }

    @FunctionalInterface
    public static interface RecordConverter<R> {
        public R convert(R var1);
    }
}

