/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.extractnewstate;

import io.debezium.DebeziumException;
import io.debezium.transforms.ExtractNewRecordStateConfigDefinition;
import io.debezium.transforms.extractnewstate.AbstractExtractRecordStrategy;
import io.debezium.util.Loggings;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeleteHandlingStrategy<R extends ConnectRecord<R>>
extends AbstractExtractRecordStrategy<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDeleteHandlingStrategy.class);
    private final ExtractNewRecordStateConfigDefinition.DeleteTombstoneHandling deleteTombstoneHandling;

    public DefaultDeleteHandlingStrategy(ExtractNewRecordStateConfigDefinition.DeleteTombstoneHandling deleteTombstoneHandling, boolean replaceNullWithDefault) {
        super(replaceNullWithDefault);
        this.deleteTombstoneHandling = deleteTombstoneHandling;
    }

    @Override
    public R handleTombstoneRecord(R record) {
        switch (this.deleteTombstoneHandling) {
            case DROP: 
            case TOMBSTONE: 
            case REWRITE: {
                LOGGER.trace("Tombstone {} arrived and requested to be dropped", Loggings.maybeRedactSensitiveData(((ConnectRecord)record).key()));
                return null;
            }
            case REWRITE_WITH_TOMBSTONE: {
                return record;
            }
        }
        throw new DebeziumException("Unknown delete handling mode: " + String.valueOf(this.deleteTombstoneHandling));
    }

    @Override
    public R handleDeleteRecord(R record) {
        switch (this.deleteTombstoneHandling) {
            case DROP: {
                LOGGER.trace("Delete message {} requested to be dropped", Loggings.maybeRedactSensitiveData(((ConnectRecord)record).key()));
                return null;
            }
            case TOMBSTONE: {
                return this.afterDelegate.apply(record);
            }
            case REWRITE: 
            case REWRITE_WITH_TOMBSTONE: {
                LOGGER.trace("Delete message {} requested to be rewritten", Loggings.maybeRedactSensitiveData(((ConnectRecord)record).key()));
                R oldRecord = this.beforeDelegate.apply(record);
                if (((ConnectRecord)oldRecord).value() instanceof Struct) {
                    return this.removedDelegate.apply(oldRecord);
                }
                return oldRecord;
            }
        }
        throw new DebeziumException("Unknown delete handling mode: " + String.valueOf(this.deleteTombstoneHandling));
    }

    @Override
    public R handleRecord(R record) {
        R newRecord = this.afterDelegate.apply(record);
        switch (this.deleteTombstoneHandling) {
            case REWRITE: 
            case REWRITE_WITH_TOMBSTONE: {
                LOGGER.trace("Insert/update message {} requested to be rewritten", Loggings.maybeRedactSensitiveData(((ConnectRecord)record).key()));
                if (!(((ConnectRecord)newRecord).value() instanceof Struct)) break;
                return this.updatedDelegate.apply(newRecord);
            }
        }
        return newRecord;
    }

    @Override
    public boolean isRewriteMode() {
        return this.deleteTombstoneHandling == ExtractNewRecordStateConfigDefinition.DeleteTombstoneHandling.REWRITE || this.deleteTombstoneHandling == ExtractNewRecordStateConfigDefinition.DeleteTombstoneHandling.REWRITE_WITH_TOMBSTONE;
    }
}

