/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.Module;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.transforms.SmtManager;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;

public class ExtractChangedRecordState<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    public static final Field HEADER_CHANGED_NAME = Field.create("header.changed.name").withDisplayName("Header change name.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("Specify the header changed name, default is null which means not send changes to header.");
    public static final Field HEADER_UNCHANGED_NAME = Field.create("header.unchanged.name").withDisplayName("Header unchanged name.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("Specify the header unchanged name of schema, default is null which means not send changes to header.");
    private String headerChangedName = null;
    private String headerUnchangedName = null;
    private Schema changedSchema;
    private Schema unchangedSchema;
    private SmtManager<R> smtManager;

    @Override
    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        this.smtManager = new SmtManager(config);
        if (config.getString(HEADER_CHANGED_NAME) != null) {
            this.headerChangedName = config.getString(HEADER_CHANGED_NAME);
            this.changedSchema = SchemaBuilder.array(SchemaBuilder.OPTIONAL_STRING_SCHEMA).optional().name(this.headerChangedName).build();
        }
        if (config.getString(HEADER_UNCHANGED_NAME) != null) {
            this.headerUnchangedName = config.getString(HEADER_UNCHANGED_NAME);
            this.unchangedSchema = SchemaBuilder.array(SchemaBuilder.OPTIONAL_STRING_SCHEMA).optional().name(this.headerUnchangedName).build();
        }
    }

    @Override
    public R apply(R record) {
        if (((ConnectRecord)record).value() == null || !this.smtManager.isValidEnvelope(record)) {
            return record;
        }
        Struct value = Requirements.requireStruct(((ConnectRecord)record).value(), "Record value should be struct.");
        Object after = value.get("after");
        Object before = value.get("before");
        ArrayList changedNames = new ArrayList();
        ArrayList unchangedNames = new ArrayList();
        if (after != null && before != null) {
            Struct afterValue = Requirements.requireStruct(after, "After value should be struct.");
            Struct beforeValue = Requirements.requireStruct(before, "Before value should be struct.");
            afterValue.schema().fields().forEach(field -> {
                Object beforeFieldValue;
                Object afterFieldValue = afterValue.getWithoutDefault(field.name());
                if (!Objects.equals(afterFieldValue, beforeFieldValue = beforeValue.getWithoutDefault(field.name()))) {
                    changedNames.add(field.name());
                } else {
                    unchangedNames.add(field.name());
                }
            });
        }
        if (!Strings.isNullOrBlank(this.headerChangedName)) {
            ((ConnectRecord)record).headers().add(this.headerChangedName, changedNames, this.changedSchema);
        }
        if (!Strings.isNullOrBlank(this.headerUnchangedName)) {
            ((ConnectRecord)record).headers().add(this.headerUnchangedName, unchangedNames, this.unchangedSchema);
        }
        return record;
    }

    @Override
    public void close() {
    }

    @Override
    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, HEADER_CHANGED_NAME, HEADER_UNCHANGED_NAME);
        return config;
    }

    @Override
    public String version() {
        return Module.version();
    }
}

