/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Conversions;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class IsoTime {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_TIME;
    public static final String SCHEMA_NAME = "io.debezium.time.IsoTime";
    private static final Duration ONE_DAY = Duration.ofDays(1L);

    public static SchemaBuilder builder() {
        return SchemaBuilder.string().name(SCHEMA_NAME).version(1);
    }

    public static Schema schema() {
        return IsoTime.builder().build();
    }

    public static String toIsoString(Object value, boolean acceptLargeValues) {
        if (value instanceof Duration) {
            Duration duration = (Duration)value;
            if (!acceptLargeValues && (duration.isNegative() || duration.compareTo(ONE_DAY) > 0)) {
                throw new IllegalArgumentException("Time values must be between 00:00:00 and 24:00:00 (inclusive): " + String.valueOf(duration));
            }
            LocalTime localTime = LocalTime.of(0, 0).plus(duration);
            return localTime.atOffset(ZoneOffset.UTC).format(FORMATTER);
        }
        LocalTime localTime = Conversions.toLocalTime(value);
        return localTime.atOffset(ZoneOffset.UTC).format(FORMATTER);
    }

    private IsoTime() {
    }
}

