/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.spi;

import io.debezium.DebeziumException;
import io.debezium.relational.ChangeTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChangeTableResultSet<C extends ChangeTable, T extends Comparable<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeTableResultSet.class);
    private final C changeTable;
    private ResultSet resultSet;
    private final int columnDataOffset;
    private final int maxRowsPerResultSet;
    private int rowsReadPerResultSet;
    private boolean completed = false;
    private T currentChangePosition;
    private T previousChangePosition;

    public ChangeTableResultSet(C changeTable, int columnDataOffset, int maxRowsPerResultSet) {
        this.changeTable = changeTable;
        this.columnDataOffset = columnDataOffset;
        this.maxRowsPerResultSet = maxRowsPerResultSet;
    }

    public C getChangeTable() {
        return this.changeTable;
    }

    public T getChangePosition() throws SQLException {
        return this.currentChangePosition;
    }

    protected T getPreviousChangePosition() {
        return this.previousChangePosition;
    }

    public int getOperation() throws SQLException {
        return this.getOperation(this.resultSet);
    }

    public boolean isCurrentPositionSmallerThanPreviousPosition() {
        return this.previousChangePosition != null && this.previousChangePosition.compareTo(this.currentChangePosition) > 0;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    protected abstract ResultSet getNextResultSet(T var1) throws SQLException;

    public boolean next() throws SQLException {
        if (this.resultSet == null) {
            this.resultSet = this.getNextResultSet(this.currentChangePosition);
            this.rowsReadPerResultSet = 0;
        }
        if (this.resultSet.next()) {
            ++this.rowsReadPerResultSet;
        } else {
            if (this.maxRowsPerResultSet > 0 && this.rowsReadPerResultSet > this.maxRowsPerResultSet) {
                throw new DebeziumException("Number of rows read from the result set is greater than the configured max rows per a result set");
            }
            if (this.maxRowsPerResultSet > 0 && this.rowsReadPerResultSet == this.maxRowsPerResultSet) {
                this.close();
                return this.next();
            }
            this.completed = true;
        }
        this.previousChangePosition = this.currentChangePosition;
        this.currentChangePosition = this.getNextChangePosition(this.resultSet);
        if (this.completed) {
            this.close();
        }
        return !this.completed;
    }

    public void close() {
        LOGGER.trace("Closing result set of change tables for table {}", (Object)this.changeTable);
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
                this.resultSet = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object[] getData() throws SQLException {
        int dataColumnCount = this.resultSet.getMetaData().getColumnCount() - (this.columnDataOffset - 1);
        Object[] data = new Object[dataColumnCount];
        for (int i = 0; i < dataColumnCount; ++i) {
            data[i] = this.getColumnData(this.resultSet, this.columnDataOffset + i);
        }
        return data;
    }

    protected Object getColumnData(ResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.getObject(columnIndex);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public int compareTo(ChangeTableResultSet<C, T> other) throws SQLException {
        return this.getChangePosition().compareTo(other.getChangePosition());
    }

    public String toString() {
        return "ChangeTableResultSet{changeTable=" + String.valueOf(this.changeTable) + ", resultSet=" + String.valueOf(this.resultSet) + ", completed=" + this.completed + ", currentChangePosition=" + String.valueOf(this.currentChangePosition) + "}";
    }

    protected abstract int getOperation(ResultSet var1) throws SQLException;

    protected abstract T getNextChangePosition(ResultSet var1) throws SQLException;
}

