/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal.channels.process;

import io.debezium.DebeziumException;
import io.debezium.annotation.ThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.pipeline.signal.SignalRecord;
import io.debezium.pipeline.signal.channels.SignalChannelReader;
import io.debezium.pipeline.signal.channels.process.SignalChannelWriter;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class InProcessSignalChannel
implements SignalChannelReader,
SignalChannelWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InProcessSignalChannel.class);
    public static final String CHANNEL_NAME = "in-process";
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final Queue<SignalRecord> signals = new ConcurrentLinkedQueue<SignalRecord>();

    @Override
    public String name() {
        return CHANNEL_NAME;
    }

    @Override
    public void init(CommonConnectorConfig connectorConfig) {
        this.open.compareAndSet(false, true);
        LOGGER.info("Reading signals from {} channel", (Object)CHANNEL_NAME);
    }

    @Override
    public List<SignalRecord> read() {
        if (!this.open.get()) {
            return List.of();
        }
        return Stream.ofNullable(this.signals.poll()).toList();
    }

    @Override
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            this.drain();
        }
    }

    private void drain() {
        while (!this.signals.isEmpty()) {
            this.signals.clear();
        }
    }

    @Override
    public void signal(SignalRecord signal) {
        if (!this.open.get()) {
            throw new DebeziumException("Channel already closed");
        }
        this.signals.add(signal);
    }
}

