/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal.channels;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import io.debezium.pipeline.signal.SignalRecord;
import io.debezium.pipeline.signal.channels.SignalChannelReader;
import io.debezium.util.Collect;
import io.debezium.util.Loggings;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSignalChannel
implements SignalChannelReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSignalChannel.class);
    public static final String CONFIGURATION_FIELD_PREFIX_STRING = "signal.";
    private static final String CONSUMER_PREFIX = "signal.consumer.";
    public static final String CHANNEL_OFFSET = "channelOffset";
    public static final String CHANNEL_NAME = "kafka";
    private String topicName;
    private String connectorName;
    private Duration pollTimeoutMs;
    private KafkaConsumer<String, String> signalsConsumer;
    public static final Field SIGNAL_TOPIC = Field.create("signal.kafka.topic").withDisplayName("Signal topic name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDescription("The name of the topic for the signals to the connector").withValidation(Field::isRequired);
    public static final Field BOOTSTRAP_SERVERS = Field.create("signal.kafka.bootstrap.servers").withDisplayName("Kafka broker addresses").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDescription("A list of host/port pairs that the connector will use for establishing the initial connection to the Kafka cluster for retrieving signals to the connector.This should point to the same Kafka cluster used by the Kafka Connect process.").withValidation(Field::isRequired);
    public static final Field SIGNAL_POLL_TIMEOUT_MS = Field.create("signal.kafka.poll.timeout.ms").withDisplayName("Poll timeout for kafka signals (ms)").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The number of milliseconds to wait while polling signals.").withDefault(0).withValidation(Field::isNonNegativeInteger);
    public static final Field GROUP_ID = Field.create("signal.kafka.groupId").withDisplayName("Consumer group id for the signal topic").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Consumer group id for the signal topic").withDefault("kafka-signal");
    private static final Field.Set ALL_FIELDS = Field.setOf(SIGNAL_TOPIC, BOOTSTRAP_SERVERS, SIGNAL_POLL_TIMEOUT_MS, GROUP_ID);

    private Optional<SignalRecord> processSignal(ConsumerRecord<String, String> record) {
        if (!this.connectorName.equals(record.key())) {
            LOGGER.info("Signal key '{}' doesn't match the connector's name '{}'", (Object)record.key(), (Object)this.connectorName);
            return Optional.empty();
        }
        String value = record.value();
        LOGGER.trace("Processing signal: {}", (Object)value);
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        Optional<Document> jsonData = KafkaSignalChannel.parseJson(value);
        if (jsonData.isEmpty()) {
            return Optional.empty();
        }
        Document document = jsonData.get();
        String id = document.getString("id");
        String type = document.getString("type");
        Document data = document.getDocument("data");
        return Optional.of(new SignalRecord(id, type, data.toString(), Map.of(CHANNEL_OFFSET, record.offset())));
    }

    private static Optional<Document> parseJson(String value) {
        Document jsonData;
        try {
            jsonData = DocumentReader.defaultReader().read(value);
        }
        catch (IOException e) {
            Loggings.logErrorAndTraceRecord(LOGGER, (Object)value, "Skipped signal due to an error", e);
            return Optional.empty();
        }
        return Optional.of(jsonData);
    }

    public void seek(long signalOffset) {
        this.signalsConsumer.seek(new TopicPartition(this.topicName, 0), signalOffset + 1L);
    }

    @Override
    public String name() {
        return CHANNEL_NAME;
    }

    @Override
    public void init(CommonConnectorConfig connectorConfig) {
        this.connectorName = connectorConfig.getLogicalName();
        Configuration signalConfig = ((Configuration.Builder)connectorConfig.getConfig().subset(CONFIGURATION_FIELD_PREFIX_STRING, false).edit().withDefault(SIGNAL_TOPIC, this.connectorName + "-signal")).build();
        if (!signalConfig.validateAndRecord(ALL_FIELDS, LOGGER::error)) {
            throw new DebeziumException("Signal channel kafka configuration is invalid. See logs for details.");
        }
        this.topicName = signalConfig.getString(SIGNAL_TOPIC);
        this.pollTimeoutMs = Duration.ofMillis(signalConfig.getInteger(SIGNAL_POLL_TIMEOUT_MS));
        Configuration consumerConfig = KafkaSignalChannel.buildKafkaConfiguration(signalConfig);
        this.signalsConsumer = new KafkaConsumer(consumerConfig.asProperties());
        LOGGER.info("Subscribing to signals topic '{}'", (Object)this.topicName);
        this.signalsConsumer.assign(Collect.arrayListOf(new TopicPartition(this.topicName, 0), new TopicPartition[0]));
    }

    private static Configuration buildKafkaConfiguration(Configuration signalConfig) {
        Configuration.Builder confBuilder = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)signalConfig.subset(CONSUMER_PREFIX, true).edit().withDefault("bootstrap.servers", signalConfig.getString(BOOTSTRAP_SERVERS)).withDefault("client.id", UUID.randomUUID().toString()).withDefault("group.id", signalConfig.getString(GROUP_ID)).withDefault("fetch.min.bytes", 1)).withDefault("session.timeout.ms", 10000)).withDefault("key.deserializer", StringDeserializer.class)).withDefault("value.deserializer", StringDeserializer.class)).withDefault("enable.auto.commit", true)).withDefault("auto.offset.reset", "earliest");
        return confBuilder.build();
    }

    @Override
    public List<SignalRecord> read() {
        LOGGER.debug("Reading signal form kafka");
        ConsumerRecords<String, String> recoveredRecords = this.signalsConsumer.poll(this.pollTimeoutMs);
        return StreamSupport.stream(recoveredRecords.spliterator(), false).map(this::processSignal).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.signalsConsumer.commitSync();
        this.signalsConsumer.close();
    }
}

