/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal.channels;

import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.hazelcast.shaded.com.fasterxml.jackson.core.type.TypeReference;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.pipeline.signal.SignalRecord;
import io.debezium.pipeline.signal.channels.SignalChannelReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSignalChannel
implements SignalChannelReader {
    public static final String CONFIGURATION_FIELD_PREFIX_STRING = "signal.";
    public static final Field SIGNAL_FILE = Field.create("signal.file").withDisplayName("Signal file name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDescription("The name of the file for the signals to the connector").withValidation(Field::isRequired);
    public static final String CHANNEL_NAME = "file";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSignalChannel.class);
    ObjectMapper mapper = new ObjectMapper();
    private File signalFile;

    @Override
    public String name() {
        return CHANNEL_NAME;
    }

    @Override
    public void init(CommonConnectorConfig connectorConfig) {
        Configuration signalConfig = ((Configuration.Builder)connectorConfig.getConfig().subset(CONFIGURATION_FIELD_PREFIX_STRING, false).edit().withDefault(SIGNAL_FILE, "file-signals.txt")).build();
        this.signalFile = new File(signalConfig.getString(SIGNAL_FILE));
        LOGGER.info("Reading '{}' file for signals", (Object)this.signalFile.getAbsolutePath());
    }

    public void reset(Object reference) {
        try (FileChannel file = FileChannel.open(Paths.get(this.signalFile.getPath(), new String[0]), StandardOpenOption.WRITE);){
            file.truncate(0L);
        }
        catch (IOException e) {
            LOGGER.error("Unable to truncate file '{}'", (Object)this.signalFile.getAbsolutePath());
        }
    }

    @Override
    public List<SignalRecord> read() {
        ArrayList<SignalRecord> signals = new ArrayList<SignalRecord>();
        if (!this.signalFile.exists() || this.signalFile.isDirectory()) {
            LOGGER.trace("Signal file not found '{}'", (Object)this.signalFile.getAbsolutePath());
            return signals;
        }
        try {
            List<String> lines = Files.readAllLines(this.signalFile.toPath());
            if (!lines.isEmpty()) {
                new FileWriter(this.signalFile, false).close();
            }
            Iterator<String> lineIterator = lines.iterator();
            while (lineIterator.hasNext()) {
                String signalLine = lineIterator.next();
                if (signalLine == null || signalLine.isBlank()) {
                    LOGGER.debug("Ignoring empty signal line: `{}`", (Object)signalLine);
                    lineIterator.remove();
                    continue;
                }
                try {
                    SignalRecord signal = this.readSignalString(signalLine);
                    signals.add(signal);
                    LOGGER.info("Processing signal: {}, {}, {}, {}", signal.getId(), signal.getType(), signal.getData(), signal.getAdditionalData());
                }
                catch (Exception e) {
                    LOGGER.warn("Skipped signal due to an error '{}'", (Object)signalLine, (Object)e);
                }
                lineIterator.remove();
            }
        }
        catch (Exception e) {
            throw new DebeziumException("Failed to read signal file " + this.signalFile.getAbsolutePath(), e);
        }
        return signals;
    }

    private SignalRecord readSignalString(String signalLine) throws JsonProcessingException {
        LOGGER.trace("Processing signal line: {}", (Object)signalLine);
        JsonNode signalJson = this.mapper.readTree(signalLine);
        Map<String, Object> additionalData = signalJson.has("additionalData") ? this.mapper.convertValue((Object)signalJson.get("additionalData"), new TypeReference<Map<String, Object>>(){}) : Map.of();
        Long channelOffset = signalJson.has("channelOffset") ? signalJson.get("channelOffset").asLong(0L) : 0L;
        String id = signalJson.get("id").asText();
        String type = signalJson.get("type").asText();
        String data = signalJson.get("data").toString();
        return new SignalRecord(id, type, data, additionalData);
    }

    @Override
    public void close() {
    }
}

