/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.metrics.activity;

import io.debezium.data.Envelope;
import io.debezium.metrics.activity.ActivityMonitoringMXBean;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.spi.schema.DataCollectionId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityMonitoringMeter
implements ActivityMonitoringMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityMonitoringMeter.class);
    private final ActivityCounter createCount = new ActivityCounter();
    private final ActivityCounter updateCount = new ActivityCounter();
    private final ActivityCounter deleteCount = new ActivityCounter();
    private final ActivityCounter truncateCount = new ActivityCounter();
    private boolean isPaused = false;

    public void onEvent(DataCollectionId source, OffsetContext offset, Object key, Struct value, Envelope.Operation operation) {
        if (this.isPaused) {
            LOGGER.trace("ActivityMonitoringMeter is paused, no metric will be collected.");
            return;
        }
        LOGGER.trace("Received record {} with key {}", (Object)value, key);
        String tableName = source.identifier();
        switch (operation) {
            case CREATE: {
                this.createCount.add(1, tableName);
                break;
            }
            case UPDATE: {
                this.updateCount.add(1, tableName);
                break;
            }
            case DELETE: {
                this.deleteCount.add(1, tableName);
                break;
            }
            case TRUNCATE: {
                this.truncateCount.add(1, tableName);
                break;
            }
        }
        LOGGER.trace("Counter status create:{}, delete:{}, update:{}, truncate:{}", this.createCount, this.deleteCount, this.updateCount, this.truncateCount);
    }

    @Override
    public Map<String, Long> getNumberOfCreateEventsSeen() {
        return this.createCount.getCounter();
    }

    @Override
    public Map<String, Long> getNumberOfDeleteEventsSeen() {
        return this.deleteCount.getCounter();
    }

    @Override
    public Map<String, Long> getNumberOfUpdateEventsSeen() {
        return this.updateCount.getCounter();
    }

    @Override
    public Map<String, Long> getNumberOfTruncateEventsSeen() {
        return this.truncateCount.getCounter();
    }

    @Override
    public void pause() {
        this.isPaused = true;
    }

    @Override
    public void resume() {
        this.isPaused = false;
    }

    public void reset() {
        this.createCount.reset();
        this.updateCount.reset();
        this.deleteCount.reset();
        this.truncateCount.reset();
    }

    public static class ActivityCounter {
        private final ConcurrentMap<String, AtomicLong> counterByCollection = new ConcurrentHashMap<String, AtomicLong>();

        public void add(int increment, String tableName) {
            this.counterByCollection.compute(tableName, (k, v) -> {
                if (v == null) {
                    return new AtomicLong(increment);
                }
                v.addAndGet(increment);
                return v;
            });
        }

        public Map<String, Long> getCounter() {
            return this.counterByCollection.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AtomicLong)e.getValue()).get()));
        }

        public void reset() {
            this.counterByCollection.clear();
        }
    }
}

