/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.async;

import io.debezium.embedded.async.AbstractRecordProcessor;
import io.debezium.embedded.async.ProcessingCallables;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.StopEngineException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelSmtAndConvertAsyncConsumerProcessor<R>
extends AbstractRecordProcessor<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelSmtAndConvertAsyncConsumerProcessor.class);
    final DebeziumEngine.RecordCommitter committer;
    final Consumer<R> consumer;
    final Function<SourceRecord, R> convertor;

    ParallelSmtAndConvertAsyncConsumerProcessor(DebeziumEngine.RecordCommitter committer, Consumer<R> consumer, Function<SourceRecord, R> convertor) {
        this.committer = committer;
        this.consumer = consumer;
        this.convertor = convertor;
    }

    @Override
    public void processRecords(List<SourceRecord> records) throws Exception {
        LOGGER.debug("Thread {} is submitting {} records for processing.", (Object)Thread.currentThread().getName(), (Object)records.size());
        Future[] recordFutures = new Future[records.size()];
        Iterator<SourceRecord> recordsIterator = records.iterator();
        int i = 0;
        while (recordsIterator.hasNext()) {
            recordFutures[i] = this.recordService.submit(new ProcessingCallables.TransformConvertConsumeRecord<R>(recordsIterator.next(), this.transformations, this.convertor, this.consumer));
            ++i;
        }
        LOGGER.trace("Waiting for the batch to finish processing.");
        recordsIterator = records.iterator();
        i = 0;
        while (recordsIterator.hasNext()) {
            try {
                recordFutures[i].get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof StopEngineException) {
                    this.committer.markProcessed(recordsIterator.next());
                }
                throw e;
            }
            this.committer.markProcessed(recordsIterator.next());
            ++i;
        }
        LOGGER.trace("Marking batch as finished.");
        this.committer.markBatchFinished();
    }
}

