/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.engine.ChangeEvent;
import io.debezium.engine.Header;
import io.debezium.engine.RecordChangeEvent;
import java.util.List;
import org.apache.kafka.connect.source.SourceRecord;

public class EmbeddedEngineChangeEvent<K, V, H>
implements ChangeEvent<K, V>,
RecordChangeEvent<V> {
    private final K key;
    private final V value;
    private final List<Header<H>> headers;
    private final SourceRecord sourceRecord;

    EmbeddedEngineChangeEvent(K key, V value, List<Header<H>> headers, SourceRecord sourceRecord) {
        this.key = key;
        this.value = value;
        this.headers = headers;
        this.sourceRecord = sourceRecord;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public List<Header<H>> headers() {
        return this.headers;
    }

    @Override
    public V record() {
        return this.value;
    }

    @Override
    public String destination() {
        return this.sourceRecord.topic();
    }

    @Override
    public Integer partition() {
        return this.sourceRecord.kafkaPartition();
    }

    public SourceRecord sourceRecord() {
        return this.sourceRecord;
    }

    public String toString() {
        return "EmbeddedEngineChangeEvent [key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + ", sourceRecord=" + String.valueOf(this.sourceRecord) + "]";
    }
}

