/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.recordandmetadata;

import io.debezium.converters.recordandmetadata.RecordAndMetadata;
import io.debezium.util.Collect;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;

public class RecordAndMetadataBaseImpl
implements RecordAndMetadata {
    protected static final Set<String> SOURCE_FIELDS = Collect.unmodifiableSet("version", "connector", "name", "ts_ms", "snapshot", "db");
    private final Struct record;
    private final Schema originalDataSchema;

    public RecordAndMetadataBaseImpl(Struct record, Schema originalDataSchema) {
        this.record = record;
        this.originalDataSchema = originalDataSchema;
    }

    @Override
    public String id() {
        return null;
    }

    @Override
    public String type() {
        return null;
    }

    @Override
    public Struct source() {
        return this.record.getStruct("source");
    }

    @Override
    public String operation() {
        return this.record.getString("op");
    }

    @Override
    public Struct transaction() {
        return this.record.schema().field("transaction") != null ? this.record.getStruct("transaction") : null;
    }

    @Override
    public SchemaAndValue timestamp() {
        String ts_ms = this.record.getInt64("ts_ms").toString();
        Schema ts_msSchema = this.originalDataSchema.field("ts_ms").schema();
        return new SchemaAndValue(ts_msSchema, ts_ms);
    }

    @Override
    public String traceParent() {
        throw new DataException("Value for `traceparent` CloudEvents field currently can't be obtained from a record value and can only be obtained from a record header");
    }

    @Override
    public String dataSchemaName() {
        String connectorType = this.source().getString("connector");
        return "io.debezium.connector." + connectorType + ".Data";
    }

    @Override
    public Schema dataSchema(String ... dataFields) {
        SchemaBuilder builder = SchemaBuilder.struct().name(this.dataSchemaName());
        if (dataFields.length == 0) {
            for (Field field : this.originalDataSchema.fields()) {
                builder.field(field.name(), field.schema());
            }
        } else {
            for (String field : dataFields) {
                builder.field(field, this.originalDataSchema.field(field).schema());
            }
        }
        return builder.build();
    }

    @Override
    public Struct data(String ... dataFields) {
        Schema dataSchema = this.dataSchema(dataFields);
        Struct data = new Struct(dataSchema);
        for (Field field : dataSchema.fields()) {
            data.put(field, this.record.get(field));
        }
        return data;
    }

    @Override
    public String connectorType() {
        return this.source().getString("connector");
    }

    @Override
    public Object sourceField(String name, Set<String> connectorSpecificSourceFields) {
        if (SOURCE_FIELDS.contains(name)) {
            return this.source().get(name);
        }
        if (connectorSpecificSourceFields.contains(name)) {
            return this.source().get(name);
        }
        throw new DataException("No such field \"" + name + "\" in the \"source\" field of events from " + this.connectorType() + " connector");
    }
}

