/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.jet.cdc.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.enterprise.jet.cdc.CdcSinks;
import com.hazelcast.enterprise.jet.cdc.ChangeRecord;
import com.hazelcast.enterprise.jet.cdc.impl.Utils;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.connector.AbstractUpdateMapP;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;

public class WriteCdcP<K, V>
extends AbstractUpdateMapP<ChangeRecord, K, V> {
    private static final int MAX_PARALLEL_ASYNC_OPS = 1;
    private static final int INITIAL_CAPACITY = 4096;
    private static final float LOAD_FACTOR = 0.75f;
    private final FunctionEx<? super ChangeRecord, ? extends V> valueFn;
    private LinkedHashMap<K, Sequence> sequences;

    public WriteCdcP(@Nonnull HazelcastInstance instance, @Nonnull String map, @Nonnull FunctionEx<? super ChangeRecord, ? extends K> keyFn, @Nonnull FunctionEx<? super ChangeRecord, ? extends V> valueFn) {
        super(instance, 1, map, keyFn);
        this.valueFn = valueFn;
    }

    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        super.init(outbox, context);
        Utils.checkLicense(context);
        Properties properties = context.hazelcastInstance().getConfig().getProperties();
        HazelcastProperties hzProperties = new HazelcastProperties(properties);
        final long expirationMs = hzProperties.getMillis(CdcSinks.SEQUENCE_CACHE_EXPIRATION_SECONDS);
        this.sequences = new LinkedHashMap<K, Sequence>(4096, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, Sequence> eldest) {
                return eldest.getValue().isOlderThan(expirationMs);
            }
        };
    }

    boolean updateSequence(K key, long source, long sequence) {
        Sequence prevSequence = this.sequences.get(key);
        if (prevSequence == null) {
            this.sequences.put(key, new Sequence(source, sequence));
            return true;
        }
        return prevSequence.update(source, sequence);
    }

    protected void addToBuffer(ChangeRecord item) {
        Data value;
        Object key = this.keyFn.apply((Object)item);
        if (this.shouldBeDropped(key, item)) {
            --this.pendingItemCount;
            return;
        }
        Data keyData = this.serializationContext.toKeyData(key);
        int partitionId = this.serializationContext.partitionId(keyData);
        Map buffer = this.partitionBuffers[partitionId];
        if (buffer.put(keyData, value = this.serializationContext.toData(this.valueFn.apply((Object)item))) == null) {
            int n = partitionId;
            this.pendingInPartition[n] = this.pendingInPartition[n] + 1;
        } else {
            --this.pendingItemCount;
        }
    }

    private boolean shouldBeDropped(K key, ChangeRecord item) {
        long sequenceValue;
        long sequenceSource = item.sequenceSource();
        return !this.updateSequence(key, sequenceSource, sequenceValue = item.sequenceValue());
    }

    protected EntryProcessor<K, V, Void> entryProcessor(Map<Data, Object> buffer) {
        return new AbstractUpdateMapP.ApplyValuesEntryProcessor(buffer);
    }

    private static class Sequence {
        private long timestamp = System.currentTimeMillis();
        private long source;
        private long sequence;

        Sequence(long source, long sequence) {
            this.source = source;
            this.sequence = sequence;
        }

        boolean isOlderThan(long ageLimitMs) {
            long age = System.currentTimeMillis() - this.timestamp;
            return age > ageLimitMs;
        }

        boolean update(long source, long sequence) {
            this.timestamp = System.currentTimeMillis();
            if (this.source != source) {
                this.source = source;
                this.sequence = sequence;
                return true;
            }
            if (this.sequence < sequence) {
                this.sequence = sequence;
                return true;
            }
            return false;
        }
    }
}

