/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.jet.cdc.impl;

import com.hazelcast.enterprise.jet.cdc.ParsingException;
import com.hazelcast.enterprise.jet.cdc.impl.Utils;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public final class StructToMap {
    private static final Set<String> TIME_SCHEMAS = Set.of("io.debezium.time.Time", "org.apache.kafka.connect.data.Time");

    private StructToMap() {
    }

    public static Map<String, Object> toMap(Struct struct) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Field field : struct.schema().fields()) {
            Map<String, Object> object = struct.get(field.name());
            Schema schema = field.schema();
            object = switch (schema.type()) {
                case Schema.Type.STRUCT -> StructToMap.toMap((Struct)((Object)object));
                case Schema.Type.INT32 -> StructToMap.checkInt32ForDate(object, schema);
                case Schema.Type.INT64 -> StructToMap.checkInt64ForDate(object, schema);
                default -> object;
            };
            result.put(field.name(), object);
        }
        return result;
    }

    private static Object checkInt32ForDate(Object object, Schema schema) {
        if (schema.name() == null) {
            return object;
        }
        if (object instanceof Integer) {
            Integer value = (Integer)object;
            return switch (schema.name()) {
                case "io.debezium.time.Date" -> LocalDate.ofEpochDay(value.intValue());
                case "io.debezium.time.Time" -> Duration.ofMillis(value.intValue());
                default -> object;
            };
        }
        if (object instanceof Date) {
            Date value = (Date)object;
            if (TIME_SCHEMAS.contains(schema.name())) {
                return Duration.ofMillis(value.getTime());
            }
        }
        return object;
    }

    private static Object checkInt64ForDate(Object object, Schema schema) {
        if (schema.name() == null) {
            return object;
        }
        if (object instanceof Long) {
            Long value = (Long)object;
            return switch (schema.name()) {
                case "io.debezium.time.Timestamp" -> new Date(value).toInstant();
                case "io.debezium.time.MicroTimestamp" -> {
                    long nanos = TimeUnit.MICROSECONDS.toNanos(value);
                    yield Instant.EPOCH.plusNanos(nanos);
                }
                case "io.debezium.time.MicroTime" -> {
                    long nanos = TimeUnit.MICROSECONDS.toNanos(value);
                    yield Duration.ofNanos(nanos);
                }
                case "io.debezium.time.NanoTimestamp" -> Instant.EPOCH.plusNanos(value);
                case "io.debezium.time.NanoTime" -> Duration.ofNanos(value);
                default -> object;
            };
        }
        if (object instanceof Date) {
            Date value = (Date)object;
            if (schema.name().equals("io.debezium.time.NanoTime")) {
                return Duration.ofNanos(value.getTime());
            }
            if (schema.name().equals("io.debezium.time.MicroTime")) {
                long nanos = TimeUnit.MICROSECONDS.toNanos(value.getTime());
                return Duration.ofNanos(nanos);
            }
        }
        return object;
    }

    public static String toJson(Struct struct) {
        try {
            return Utils.MAPPER.writeValueAsString(StructToMap.toMap(struct));
        }
        catch (JsonProcessingException e) {
            throw new ParsingException("Unable to parse struct", e);
        }
    }

    public static String toJson(Object o) {
        if (o instanceof Struct) {
            Struct s = (Struct)o;
            return StructToMap.toJson(s);
        }
        if (o instanceof String) {
            String s = (String)o;
            return s;
        }
        try {
            return Utils.MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new ParsingException("Unable to parse struct", e);
        }
    }
}

