/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.jet.cdc.impl;

import com.hazelcast.enterprise.jet.cdc.impl.Utils;
import io.debezium.relational.history.HistoryRecord;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;

public final class State {
    private static final Map<Long, State> STATES = new ConcurrentHashMap<Long, State>();
    private final Map<ByteBuffer, ByteBuffer> partitionsToOffset;
    private final List<HistoryRecord> historyRecords;
    private long jobId;

    State() {
        this(new ConcurrentHashMap<ByteBuffer, ByteBuffer>(), new CopyOnWriteArrayList<HistoryRecord>());
    }

    public State(long jobId) {
        this();
        this.jobId = jobId;
    }

    State(Map<ByteBuffer, ByteBuffer> partitionsToOffset, CopyOnWriteArrayList<HistoryRecord> historyRecords) {
        this.partitionsToOffset = partitionsToOffset;
        this.historyRecords = historyRecords;
    }

    @Nonnull
    static State getOrCreate(long jobId) {
        return Objects.requireNonNull(STATES.computeIfAbsent(jobId, k -> new State(jobId)), "state returned cannot be null");
    }

    @Nonnull
    static State get(long jobId) {
        return Objects.requireNonNull(STATES.get(jobId), "state returned cannot be null");
    }

    ByteBuffer getOffset(ByteBuffer partition) {
        return this.partitionsToOffset.get(partition);
    }

    void setOffset(ByteBuffer partition, ByteBuffer offset) {
        this.partitionsToOffset.put(partition, offset);
    }

    Map<ByteBuffer, ByteBuffer> getPartitionsToOffset() {
        return this.partitionsToOffset;
    }

    List<HistoryRecord> getHistoryRecords() {
        return this.historyRecords;
    }

    void restore(State value) {
        this.partitionsToOffset.putAll(value.partitionsToOffset);
        this.historyRecords.addAll(value.historyRecords);
    }

    void addHistory(HistoryRecord record) {
        this.historyRecords.add(record);
    }

    void remove() {
        STATES.remove(this.jobId);
    }

    public String toString() {
        return "State {\n\tjobId=" + this.jobId + "\n\tpartitionsToOffset=" + Utils.decode(this.partitionsToOffset) + ", \n\thistoryRecords=" + String.valueOf(this.historyRecords) + "\n}";
    }
}

