/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.jet.cdc.impl;

import com.hazelcast.internal.util.UuidUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

public class DebeziumConfig {
    private final Properties properties = new Properties();

    public DebeziumConfig(@Nonnull String name, @Nonnull String connectorClass) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(connectorClass, "connectorClass");
        this.properties.setProperty("name", name);
        this.properties.setProperty("connector.class", connectorClass);
        this.properties.setProperty("tombstones.on.delete", "false");
        this.properties.setProperty("topic.prefix", String.valueOf(UuidUtil.newUnsecureUUID()));
    }

    public void setProperty(String key, Object value) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(value, "value cannot be null for key " + key);
        this.properties.put(key, value);
    }

    public void setProperty(String key, String value) {
        this.setProperty(key, (Object)value);
    }

    public Properties toProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        return props;
    }
}

