/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.jet.cdc.impl;

import com.hazelcast.enterprise.jet.cdc.ChangeRecord;
import com.hazelcast.enterprise.jet.cdc.Operation;
import com.hazelcast.enterprise.jet.cdc.RecordMappingFunction;
import com.hazelcast.enterprise.jet.cdc.SequenceExtractor;
import com.hazelcast.enterprise.jet.cdc.impl.ChangeRecordImpl;
import com.hazelcast.enterprise.jet.cdc.impl.StructToMap;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.source.SourceRecord;

public class ChangeRecordMappingFn
implements RecordMappingFunction<ChangeRecord> {
    private static final long serialVersionUID = 1L;
    private SequenceExtractor sequenceExtractor;

    @Override
    public void init(@Nonnull Properties properties, ClassLoader classLoader) {
        try {
            this.sequenceExtractor = (SequenceExtractor)ReflectionUtils.newInstance((ClassLoader)classLoader, (String)properties.getProperty("sequence.extractor.class"), (String)"sequence extractor ");
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public ChangeRecord applyEx(SourceRecord record) {
        Supplier<String> newValueJson;
        Supplier<String> oldValueJson;
        long timestamp;
        Operation operation;
        if (record == null || record.topic().startsWith("__debezium")) {
            return null;
        }
        long sequenceSource = this.sequenceExtractor.source(record.sourcePartition(), record.sourceOffset());
        long sequenceValue = this.sequenceExtractor.sequence(record.sourceOffset());
        String keyJson = Values.convertToString(record.keySchema(), record.key());
        Struct value = (Struct)record.value();
        Schema valueSchema = record.valueSchema();
        Struct source = (Struct)value.get("source");
        Schema sourceSchema = valueSchema.field("source").schema();
        Supplier<String> sourceJson = () -> Values.convertToString(sourceSchema, source);
        Operation operation2 = operation = value.schema().field("op") != null ? Operation.get(value.getString("op")) : Operation.UNSPECIFIED;
        if (operation == Operation.UNSPECIFIED) {
            timestamp = ((Struct)value.get("source")).getInt64("ts_ms");
            oldValueJson = () -> Values.convertToString(valueSchema, value);
            newValueJson = () -> Values.convertToString(valueSchema, value);
        } else {
            Object before = valueSchema.field("before") != null ? value.get("before") : null;
            Object after = valueSchema.field("after") != null ? value.get("after") : null;
            timestamp = value.getInt64("ts_ms");
            oldValueJson = before == null ? null : () -> StructToMap.toJson(before);
            newValueJson = after == null ? null : () -> StructToMap.toJson(after);
        }
        return new ChangeRecordImpl(timestamp, sequenceSource, sequenceValue, operation, keyJson, sourceJson, oldValueJson, newValueJson, ChangeRecordMappingFn.fieldOrNull(source, "table"), ChangeRecordMappingFn.fieldOrNull(source, "schema"), ChangeRecordMappingFn.fieldOrNull(source, "db"));
    }

    private static String fieldOrNull(Struct struct, String fieldName) {
        return struct.schema().field(fieldName) != null ? struct.getString(fieldName) : null;
    }
}

