/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.jet.cdc;

import com.hazelcast.enterprise.jet.cdc.ChangeRecord;
import com.hazelcast.enterprise.jet.cdc.RecordMappingFunction;
import com.hazelcast.enterprise.jet.cdc.SequenceExtractor;
import com.hazelcast.enterprise.jet.cdc.impl.ChangeRecordMappingFn;
import com.hazelcast.enterprise.jet.cdc.impl.ConstantSequenceExtractor;
import com.hazelcast.enterprise.jet.cdc.impl.DebeziumConfig;
import com.hazelcast.enterprise.jet.cdc.impl.JsonRecordMappingFn;
import com.hazelcast.enterprise.jet.cdc.impl.ReadCdcP;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import io.debezium.embedded.ConvertingEngineBuilderFactory;
import io.debezium.embedded.async.ConvertingAsyncEngineBuilderFactory;
import io.debezium.engine.DebeziumEngine;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.kafka.connect.source.SourceConnector;

public final class DebeziumCdcSources {
    private DebeziumCdcSources() {
    }

    @Nonnull
    public static Builder<ChangeRecord> debezium(@Nonnull String name, @Nonnull String connectorClass) {
        return new Builder<ChangeRecord>(name, connectorClass, new ChangeRecordMappingFn());
    }

    @Nonnull
    public static Builder<ChangeRecord> debezium(@Nonnull String name, @Nonnull Class<?> connectorClass) {
        Preconditions.checkState((boolean)SourceConnector.class.isAssignableFrom(connectorClass), (String)"connector class must be a subclass of SourceConnector");
        return new Builder<ChangeRecord>(name, connectorClass.getName(), new ChangeRecordMappingFn());
    }

    @Nonnull
    public static Builder<Map.Entry<String, String>> debeziumJson(@Nonnull String name, @Nonnull String connectorClass) {
        return new Builder<Map.Entry<String, String>>(name, connectorClass, new JsonRecordMappingFn());
    }

    @Nonnull
    public static Builder<Map.Entry<String, String>> debeziumJson(@Nonnull String name, @Nonnull Class<?> connectorClass) {
        Preconditions.checkState((boolean)SourceConnector.class.isAssignableFrom(connectorClass), (String)"connector class must be a subclass of SourceConnector");
        return new Builder<Map.Entry<String, String>>(name, connectorClass.getName(), new JsonRecordMappingFn());
    }

    public static class Builder<T> {
        protected final DebeziumConfig config;
        protected RecordMappingFunction<T> recordMappingFunction;
        protected SupplierEx<DebeziumEngine.BuilderFactory> engineBuilderSupplier;

        protected Builder(@Nonnull String name, @Nonnull String connectorClass, @Nonnull RecordMappingFunction<T> recordMappingFunction) {
            this.config = new DebeziumConfig(name, connectorClass);
            this.config.setProperty("sequence.extractor.class", ConstantSequenceExtractor.class.getName());
            this.recordMappingFunction = recordMappingFunction;
            this.withDefaultEngine();
        }

        @Nonnull
        public Builder<ChangeRecord> changeRecord() {
            this.recordMappingFunction = new ChangeRecordMappingFn();
            return this;
        }

        @Nonnull
        public Builder<Map.Entry<String, String>> json() {
            this.recordMappingFunction = new JsonRecordMappingFn();
            return this;
        }

        @Nonnull
        public <T_NEW> Builder<T_NEW> customMapping(@Nonnull RecordMappingFunction<T_NEW> recordMappingFunction) {
            Util.checkNonNullAndSerializable(recordMappingFunction, (String)"recordMappingFunction");
            this.recordMappingFunction = recordMappingFunction;
            return this;
        }

        @Nonnull
        public Builder<T> withSequenceExtractor(Class<? extends SequenceExtractor> sequenceExtractorClass) {
            this.config.setProperty("sequence.extractor.class", sequenceExtractorClass.getName());
            return this;
        }

        @Nonnull
        public Builder<T> withDefaultEngine() {
            this.engineBuilderSupplier = new DefaultEngineSupplier();
            return this;
        }

        @Nonnull
        public Builder<T> withAsyncEngine() {
            this.engineBuilderSupplier = new AsyncEngineSupplier();
            return this;
        }

        @Nonnull
        public Builder<T> withErrorMaxRetries(int errorRetryCount) {
            this.config.setProperty("errors.max.retries", String.valueOf(errorRetryCount));
            return this;
        }

        @Nonnull
        public Builder<T> setDatabaseIncludeList(String ... databaseNameRegExps) {
            this.config.setProperty("database.include.list", String.join((CharSequence)",", databaseNameRegExps));
            return this;
        }

        @Nonnull
        public Builder<T> setDatabaseExcludeList(String ... databaseNameRegExps) {
            this.config.setProperty("database.exclude.list", databaseNameRegExps);
            return this;
        }

        @Nonnull
        public Builder<T> setTableIncludeList(String ... tableNameRegExps) {
            this.config.setProperty("table.include.list", String.join((CharSequence)",", tableNameRegExps));
            return this;
        }

        @Nonnull
        public Builder<T> setTableExcludeList(String ... tableNameRegExps) {
            this.config.setProperty("table.exclude.list", tableNameRegExps);
            return this;
        }

        @Nonnull
        public Builder<T> setProperty(@Nonnull String key, @Nonnull String value) {
            this.config.setProperty(key, value);
            return this;
        }

        @Nonnull
        public Builder<T> setProperty(@Nonnull String key, int value) {
            this.setProperty(key, Integer.toString(value));
            return this;
        }

        @Nonnull
        public Builder<T> setProperty(@Nonnull String key, long value) {
            this.setProperty(key, Long.toString(value));
            return this;
        }

        @Nonnull
        public Builder<T> setProperty(@Nonnull String key, boolean value) {
            this.setProperty(key, Boolean.toString(value));
            return this;
        }

        @Nonnull
        public StreamSource<T> build() {
            Properties properties = this.config.toProperties();
            RecordMappingFunction recordMappingFunction = this.recordMappingFunction;
            SupplierEx<DebeziumEngine.BuilderFactory> engineBuilderSupplier = this.engineBuilderSupplier;
            String name = properties.getProperty("name");
            return Sources.streamFromProcessorWithWatermarks((String)name, (boolean)true, (FunctionEx & Serializable)eventTimePolicy -> {
                ProcessorSupplier supplier = ProcessorSupplier.of((SupplierEx & Serializable)() -> new ReadCdcP(properties, eventTimePolicy, recordMappingFunction, engineBuilderSupplier));
                return ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)supplier);
            });
        }
    }

    private static class AsyncEngineSupplier
    implements SupplierEx<DebeziumEngine.BuilderFactory> {
        private static final long serialVersionUID = 1L;

        private AsyncEngineSupplier() {
        }

        public DebeziumEngine.BuilderFactory getEx() {
            return new ConvertingAsyncEngineBuilderFactory();
        }
    }

    private static class DefaultEngineSupplier
    implements SupplierEx<DebeziumEngine.BuilderFactory> {
        private static final long serialVersionUID = 1L;

        private DefaultEngineSupplier() {
        }

        public DebeziumEngine.BuilderFactory getEx() {
            return new ConvertingEngineBuilderFactory();
        }
    }
}

