/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.avro;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.avro.AvroSourceBuilder;
import com.hazelcast.jet.pipeline.BatchSource;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;

public final class AvroSources {
    static final String AVRO_SOURCE_CONNECTOR_NAME = "avroSource";

    private AvroSources() {
    }

    @Nonnull
    public static <D> AvroSourceBuilder<D> filesBuilder(@Nonnull String directory, @Nonnull Class<D> recordClass) {
        return AvroSources.filesBuilder(directory, (SupplierEx & Serializable)() -> SpecificRecord.class.isAssignableFrom(recordClass) ? new SpecificDatumReader(recordClass) : new ReflectDatumReader(recordClass));
    }

    @Nonnull
    public static <D> AvroSourceBuilder<D> filesBuilder(@Nonnull String directory, @Nonnull SupplierEx<? extends DatumReader<D>> datumReaderSupplier) {
        return new AvroSourceBuilder(directory, datumReaderSupplier);
    }

    @Nonnull
    public static <D> BatchSource<D> files(@Nonnull String directory, @Nonnull Class<D> datumClass) {
        return AvroSources.filesBuilder(directory, datumClass).build();
    }

    @Nonnull
    public static <D> BatchSource<D> files(@Nonnull String directory, @Nonnull BiFunctionEx<String, GenericRecord, D> mapOutputFn) {
        return AvroSources.filesBuilder(directory, GenericDatumReader::new).build(mapOutputFn);
    }
}

