/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.avro;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.avro.AvroProcessors;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;

public final class AvroSinks {
    static final String AVRO_SINK_CONNECTOR_NAME = "avroSink";

    private AvroSinks() {
    }

    @Nonnull
    public static <R> Sink<R> files(@Nonnull String directoryName, @Nonnull Schema schema, @Nonnull SupplierEx<DatumWriter<R>> datumWriterSupplier) {
        return Sinks.fromProcessor((String)("avroFilesSink(" + directoryName + ")"), (ProcessorMetaSupplier)AvroProcessors.writeFilesP(directoryName, schema, datumWriterSupplier, AVRO_SINK_CONNECTOR_NAME));
    }

    @Nonnull
    public static <R> Sink<R> files(@Nonnull String directoryName, @Nonnull Class<R> recordClass, @Nonnull Schema schema) {
        return AvroSinks.files(directoryName, schema, (SupplierEx & Serializable)() -> SpecificRecord.class.isAssignableFrom(recordClass) ? new SpecificDatumWriter(recordClass) : new ReflectDatumWriter(recordClass));
    }

    @Nonnull
    public static Sink<IndexedRecord> files(@Nonnull String directoryName, @Nonnull Schema schema) {
        return AvroSinks.files(directoryName, schema, GenericDatumWriter::new);
    }
}

