/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.extract;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.LazyTarget;
import com.hazelcast.sql.impl.extract.GenericFieldExtractor;
import com.hazelcast.sql.impl.extract.GenericTargetAccessor;
import com.hazelcast.sql.impl.extract.GenericTargetExtractor;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;

public class GenericQueryTarget
implements QueryTarget,
GenericTargetAccessor {
    private final InternalSerializationService serializationService;
    private final Extractors extractors;
    private final boolean key;
    private Object deserialized;
    private Data serialized;
    private LazyTarget targetWithObjectTypeForDirectAccess;
    private Object targetForFieldAccess;

    public GenericQueryTarget(InternalSerializationService serializationService, Extractors extractors, boolean key) {
        this.serializationService = serializationService;
        this.extractors = extractors;
        this.key = key;
    }

    @Override
    public void setTarget(Object target, Data targetData) {
        this.serialized = targetData;
        this.deserialized = target;
        this.targetWithObjectTypeForDirectAccess = null;
        this.targetForFieldAccess = null;
    }

    @Override
    public QueryExtractor createExtractor(String path, QueryDataType type) {
        if (path == null) {
            return new GenericTargetExtractor(this.key, this, type);
        }
        return new GenericFieldExtractor(this.key, this, type, this.extractors, path);
    }

    @Override
    public Object getTargetForFieldAccess() {
        if (this.targetForFieldAccess == null) {
            this.targetForFieldAccess = this.prepareTargetForFieldAccess();
        }
        return this.targetForFieldAccess;
    }

    private Object prepareTargetForFieldAccess() {
        if (this.targetWithObjectTypeForDirectAccess != null) {
            this.deserialized = this.targetWithObjectTypeForDirectAccess.getDeserialized();
            this.serialized = this.targetWithObjectTypeForDirectAccess.getSerialized();
        }
        if (this.deserialized != null) {
            if (this.deserialized instanceof Portable || this.serializationService.isCompactSerializable(this.deserialized)) {
                if (this.serialized == null) {
                    this.serialized = this.serializationService.toData(this.deserialized);
                    if (this.targetWithObjectTypeForDirectAccess != null) {
                        this.targetWithObjectTypeForDirectAccess.setSerialized(this.serialized);
                    }
                }
                return this.serialized;
            }
            return this.deserialized;
        }
        assert (this.serialized != null);
        if (this.serialized.isPortable() || this.serialized.isCompact()) {
            return this.serialized;
        }
        if (this.deserialized == null) {
            this.deserialized = this.serializationService.toObject((Object)this.serialized);
            if (this.targetWithObjectTypeForDirectAccess != null) {
                this.targetWithObjectTypeForDirectAccess.setDeserialized(this.deserialized);
            }
        }
        return this.deserialized;
    }

    @Override
    public Object getTargetForDirectAccess(QueryDataType type) {
        if (type.getTypeFamily() != QueryDataTypeFamily.OBJECT) {
            if (this.deserialized == null) {
                this.deserialized = this.serializationService.toObject((Object)this.serialized);
            }
            return type.normalize(this.deserialized);
        }
        if (this.targetWithObjectTypeForDirectAccess == null) {
            this.targetWithObjectTypeForDirectAccess = new LazyTarget(this.serialized, this.deserialized);
        }
        return this.targetWithObjectTypeForDirectAccess;
    }

    public boolean isKey() {
        return this.key;
    }
}

