/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.datetime;

import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UniExpression;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public final class ToTimestampTzFunction
extends UniExpression<OffsetDateTime> {
    private static final long MILLISECONDS_IN_YEAR = 31536000000L;
    private static final long MICROSECONDS_IN_YEAR = 31536000000000L;
    private static final long NANOSECONDS_IN_YEAR = 31536000000000000L;

    public ToTimestampTzFunction() {
    }

    private ToTimestampTzFunction(Expression<?> operand) {
        super(operand);
    }

    public static ToTimestampTzFunction create(Expression<?> operand) {
        return new ToTimestampTzFunction(operand);
    }

    public int getClassId() {
        return 73;
    }

    @Override
    public OffsetDateTime eval(Row row, ExpressionEvalContext context) {
        Long unixTimestamp = (Long)this.operand.eval(row, context);
        if (unixTimestamp == null) {
            return null;
        }
        TemporalUnit unit = this.getChronoUnit(unixTimestamp);
        Instant instant = Instant.EPOCH.plus((long)unixTimestamp, unit);
        return OffsetDateTime.from(instant.atZone(ZoneOffset.systemDefault()));
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME;
    }

    private TemporalUnit getChronoUnit(long unixTimestamp) {
        if (unixTimestamp < 31536000000L) {
            return ChronoUnit.SECONDS;
        }
        if (unixTimestamp < 31536000000000L) {
            return ChronoUnit.MILLIS;
        }
        if (unixTimestamp < 31536000000000000L) {
            return ChronoUnit.MICROS;
        }
        return ChronoUnit.NANOS;
    }
}

