/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.precision;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateList;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiPolygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.GeometryTransformer;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.PrecisionReducer;

class PrecisionReducerTransformer
extends GeometryTransformer {
    private PrecisionModel targetPM;
    private boolean isRemoveCollapsed = false;

    public static Geometry reduce(Geometry geom, PrecisionModel targetPM, boolean isRemoveCollapsed) {
        PrecisionReducerTransformer trans = new PrecisionReducerTransformer(targetPM, isRemoveCollapsed);
        return trans.transform(geom);
    }

    PrecisionReducerTransformer(PrecisionModel targetPM, boolean isRemoveCollapsed) {
        this.targetPM = targetPM;
        this.isRemoveCollapsed = isRemoveCollapsed;
    }

    @Override
    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinates, Geometry parent) {
        if (coordinates.size() == 0) {
            return null;
        }
        Coordinate[] coordsReduce = this.reduceCompress(coordinates);
        int minSize = 0;
        if (parent instanceof LineString) {
            minSize = 2;
        }
        if (parent instanceof LinearRing) {
            minSize = 3;
        }
        if (coordsReduce.length < minSize) {
            if (this.isRemoveCollapsed) {
                return null;
            }
            coordsReduce = this.extend(coordsReduce, minSize);
        }
        return this.factory.getCoordinateSequenceFactory().create(coordsReduce);
    }

    private Coordinate[] extend(Coordinate[] coords, int minLength) {
        if (coords.length >= minLength) {
            return coords;
        }
        Coordinate[] exCoords = new Coordinate[minLength];
        for (int i = 0; i < exCoords.length; ++i) {
            int iSrc = i < coords.length ? i : coords.length - 1;
            exCoords[i] = coords[iSrc].copy();
        }
        return exCoords;
    }

    private Coordinate[] reduceCompress(CoordinateSequence coordinates) {
        CoordinateList noRepeatCoordList = new CoordinateList();
        for (int i = 0; i < coordinates.size(); ++i) {
            Coordinate coord = coordinates.getCoordinate(i).copy();
            this.targetPM.makePrecise(coord);
            noRepeatCoordList.add(coord, false);
        }
        Coordinate[] noRepeatCoords = noRepeatCoordList.toCoordinateArray();
        return noRepeatCoords;
    }

    @Override
    protected Geometry transformPolygon(Polygon geom, Geometry parent) {
        return this.reduceArea(geom);
    }

    @Override
    protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
        return this.reduceArea(geom);
    }

    private Geometry reduceArea(Geometry geom) {
        Geometry reduced = PrecisionReducer.reducePrecision(geom, this.targetPM);
        return reduced;
    }
}

