/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.dialect;

import com.hazelcast.shaded.org.apache.calcite.config.NullCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlBinaryOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.BasicSqlType;
import com.hazelcast.shaded.org.apache.calcite.util.RelToSqlConverterUtil;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class HiveSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.HIVE).withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new HiveSqlDialect(DEFAULT_CONTEXT);
    private final boolean emulateNullDirection;

    public HiveSqlDialect(SqlDialect.Context context) {
        super(context);
        this.emulateNullDirection = context.databaseMajorVersion() < 2 || context.databaseMajorVersion() == 2 && context.databaseMinorVersion() < 1;
    }

    @Override
    protected boolean allowsAs() {
        return false;
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        HiveSqlDialect.unparseFetchUsingLimit(writer, offset, fetch);
    }

    @Override
    public @Nullable SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        if (this.emulateNullDirection) {
            return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
        }
        return null;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case POSITION: {
                SqlWriter.Frame frame = writer.startFunCall("INSTR");
                writer.sep(",");
                ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
                writer.sep(",");
                ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                if (3 == call.operandCount()) {
                    throw new RuntimeException("3rd operand Not Supported for Function INSTR in Hive");
                }
                writer.endFunCall(frame);
                break;
            }
            case MOD: {
                SqlBinaryOperator op = SqlStdOperatorTable.PERCENT_REMAINDER;
                SqlSyntax.BINARY.unparse(writer, op, call, leftPrec, rightPrec);
                break;
            }
            case TRIM: {
                RelToSqlConverterUtil.unparseHiveTrim(writer, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean supportsGroupByWithRollup() {
        return true;
    }

    @Override
    public boolean supportsGroupByWithCube() {
        return true;
    }

    @Override
    public boolean supportsApproxCountDistinct() {
        return true;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        if (type instanceof BasicSqlType) {
            switch (type.getSqlTypeName()) {
                case INTEGER: {
                    SqlAlienSystemTypeNameSpec typeNameSpec = new SqlAlienSystemTypeNameSpec("INT", type.getSqlTypeName(), SqlParserPos.ZERO);
                    return new SqlDataTypeSpec(typeNameSpec, SqlParserPos.ZERO);
                }
            }
        }
        return super.getCastSpec(type);
    }
}

