/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.jdbc;

import com.hazelcast.shaded.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.adapter.jdbc.JdbcSchema;
import com.hazelcast.shaded.org.apache.calcite.avatica.AvaticaConnection;
import com.hazelcast.shaded.org.apache.calcite.avatica.BuiltInConnectionProperty;
import com.hazelcast.shaded.org.apache.calcite.avatica.ConnectionProperty;
import com.hazelcast.shaded.org.apache.calcite.avatica.DriverVersion;
import com.hazelcast.shaded.org.apache.calcite.avatica.Handler;
import com.hazelcast.shaded.org.apache.calcite.avatica.HandlerImpl;
import com.hazelcast.shaded.org.apache.calcite.avatica.Meta;
import com.hazelcast.shaded.org.apache.calcite.avatica.UnregisteredDriver;
import com.hazelcast.shaded.org.apache.calcite.config.CalciteConnectionProperty;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteConnection;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteConnectionImpl;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteDriverVersion;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteFactory;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteMetaImpl;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalcitePrepare;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteSchema;
import com.hazelcast.shaded.org.apache.calcite.linq4j.function.Function0;
import com.hazelcast.shaded.org.apache.calcite.model.JsonSchema;
import com.hazelcast.shaded.org.apache.calcite.model.ModelHandler;
import com.hazelcast.shaded.org.apache.calcite.schema.SchemaFactory;
import com.hazelcast.shaded.org.apache.calcite.schema.impl.AbstractSchema;
import com.hazelcast.shaded.org.apache.calcite.util.JsonBuilder;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;

public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:calcite:";
    protected final @Nullable Supplier<CalcitePrepare> prepareFactory;

    public Driver() {
        this(null);
    }

    protected Driver(@Nullable Supplier<CalcitePrepare> prepareFactory) {
        this.prepareFactory = prepareFactory;
    }

    public Driver withPrepareFactory(Supplier<CalcitePrepare> prepareFactory) {
        Objects.requireNonNull(prepareFactory, "prepareFactory");
        if (this.prepareFactory == prepareFactory) {
            return this;
        }
        return new Driver(prepareFactory);
    }

    public CalcitePrepare createPrepare() {
        if (this.prepareFactory != null) {
            return this.prepareFactory.get();
        }
        return this.createPrepareFactory().apply();
    }

    @Deprecated
    protected Function0<CalcitePrepare> createPrepareFactory() {
        return CalcitePrepare.DEFAULT_FACTORY;
    }

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: 
            case JDBC_40: {
                throw new IllegalArgumentException("JDBC version not supported: " + (Object)((Object)jdbcVersion));
            }
        }
        return "com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteJdbc41Factory";
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return CalciteDriverVersion.INSTANCE;
    }

    @Override
    protected Handler createHandler() {
        return new HandlerImpl(){

            @Override
            public void onConnectionInit(AvaticaConnection connection_) throws SQLException {
                CalciteConnectionImpl connection = (CalciteConnectionImpl)connection_;
                super.onConnectionInit(connection);
                String model = this.model(connection);
                if (model != null) {
                    try {
                        new ModelHandler(connection, model);
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                }
                connection.init();
            }

            @Nullable String model(CalciteConnectionImpl connection) {
                JsonSchema.Type schemaType;
                String model = connection.config().model();
                if (model != null) {
                    return model;
                }
                SchemaFactory schemaFactory = connection.config().schemaFactory(SchemaFactory.class, null);
                Properties info = connection.getProperties();
                String schemaName = Util.first(connection.config().schema(), "adhoc");
                if (schemaFactory == null && (schemaType = connection.config().schemaType()) != null) {
                    switch (schemaType) {
                        case JDBC: {
                            schemaFactory = JdbcSchema.Factory.INSTANCE;
                            break;
                        }
                        case MAP: {
                            schemaFactory = AbstractSchema.Factory.INSTANCE;
                            break;
                        }
                    }
                }
                if (schemaFactory != null) {
                    JsonBuilder json = new JsonBuilder();
                    Map<String, @Nullable Object> root = json.map();
                    root.put("version", "1.0");
                    root.put("defaultSchema", schemaName);
                    List<@Nullable Object> schemaList = json.list();
                    root.put("schemas", schemaList);
                    Map<String, @Nullable Object> schema = json.map();
                    schemaList.add(schema);
                    schema.put("type", "custom");
                    schema.put("name", schemaName);
                    schema.put("factory", schemaFactory.getClass().getName());
                    Map<String, @Nullable Object> operandMap = json.map();
                    schema.put("operand", operandMap);
                    for (Map.Entry<String, String> entry : Util.toMap(info).entrySet()) {
                        if (!entry.getKey().startsWith("schema.")) continue;
                        operandMap.put(entry.getKey().substring("schema.".length()), entry.getValue());
                    }
                    return "inline:" + json.toJsonString(root);
                }
                return null;
            }
        };
    }

    @Override
    protected Collection<ConnectionProperty> getConnectionProperties() {
        ArrayList<ConnectionProperty> list = new ArrayList<ConnectionProperty>();
        Collections.addAll(list, BuiltInConnectionProperty.values());
        Collections.addAll(list, CalciteConnectionProperty.values());
        return list;
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        return new CalciteMetaImpl((CalciteConnectionImpl)connection);
    }

    CalciteConnection connect(CalciteSchema rootSchema, @Nullable JavaTypeFactory typeFactory) {
        return (CalciteConnection)((Object)((CalciteFactory)this.factory).newConnection(this, this.factory, CONNECT_STRING_PREFIX, new Properties(), rootSchema, typeFactory));
    }

    CalciteConnection connect(CalciteSchema rootSchema, @Nullable JavaTypeFactory typeFactory, Properties properties) {
        return (CalciteConnection)((Object)((CalciteFactory)this.factory).newConnection(this, this.factory, CONNECT_STRING_PREFIX, properties, rootSchema, typeFactory));
    }

    static {
        new Driver().register();
    }
}

