/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.HazelcastPhysicalScan;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.JoinPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Join;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinInfo;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableIntList;
import java.util.ArrayList;
import java.util.List;

public class JoinNestedLoopPhysicalRel
extends JoinPhysicalRel {
    private JoinInfo modifiedJoinInfo;

    JoinNestedLoopPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        super(cluster, traitSet, left, right, condition, joinType);
    }

    public RexNode rightFilter() {
        return ((HazelcastPhysicalScan)this.getRight()).filter();
    }

    public List<RexNode> rightProjection() {
        return ((HazelcastPhysicalScan)this.getRight()).projection();
    }

    @Override
    public JoinInfo analyzeCondition() {
        if (this.modifiedJoinInfo != null) {
            return this.modifiedJoinInfo;
        }
        JoinInfo joinInfo = super.analyzeCondition();
        if (this.getRight().getTable() == null) {
            return joinInfo;
        }
        List<Integer> leftKeys = joinInfo.leftKeys.toIntegerList();
        List<Integer> rightKeys = joinInfo.rightKeys.toIntegerList();
        HazelcastTable table = OptUtils.extractHazelcastTable(this.getRight());
        final RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        ArrayList<RexNode> additionalNonEquiConditions = new ArrayList<RexNode>();
        for (int i = 0; i < rightKeys.size(); ++i) {
            Integer rightKeyIndex = rightKeys.get(i);
            RexNode rightExpr = table.getProjects().get(rightKeyIndex);
            if (rightExpr instanceof RexInputRef) {
                rightKeys.set(i, ((RexInputRef)rightExpr).getIndex());
                continue;
            }
            rightExpr = rightExpr.accept(new RexShuttle(){

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    return rexBuilder.makeInputRef(inputRef.getType(), inputRef.getIndex() + JoinNestedLoopPhysicalRel.this.getLeft().getRowType().getFieldCount());
                }
            });
            additionalNonEquiConditions.add(rexBuilder.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, rexBuilder.makeInputRef(this.getLeft(), (int)leftKeys.get(i)), rightExpr));
            leftKeys.remove(i);
            rightKeys.remove(i);
            --i;
        }
        this.modifiedJoinInfo = new ModifiedJoinInfo(ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys), (ImmutableList<RexNode>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(joinInfo.nonEquiConditions)).addAll(additionalNonEquiConditions)).build());
        return this.modifiedJoinInfo;
    }

    @Override
    public <V> V accept(CreateDagVisitor<V> visitor) {
        return visitor.onNestedLoopJoin(this);
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new JoinNestedLoopPhysicalRel(this.getCluster(), traitSet, left, right, this.getCondition(), joinType);
    }

    protected static class ModifiedJoinInfo
    extends JoinInfo {
        protected ModifiedJoinInfo(ImmutableIntList leftKeys, ImmutableIntList rightKeys, ImmutableList<RexNode> nonEquiConditions) {
            super(leftKeys, rightKeys, nonEquiConditions);
        }
    }
}

