/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.jet.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.AbstractHazelcastConnectorSupplier;
import com.hazelcast.jet.impl.connector.AsyncHazelcastWriterP;
import com.hazelcast.jet.impl.connector.HazelcastWriters;
import com.hazelcast.jet.impl.serialization.DelegatingSerializationService;
import com.hazelcast.security.permission.VectorCollectionPermission;
import com.hazelcast.vector.VectorCollection;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.impl.VectorUtil;
import java.security.Permission;
import java.util.AbstractMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class WriteVectorCollectionP<T, K, V>
extends AsyncHazelcastWriterP {
    private static final int BUFFER_LIMIT = 1024;
    private final String collectionName;
    private final SerializationService serializationService;
    private final FunctionEx<? super T, ? extends K> toKeyFn;
    private final FunctionEx<? super T, VectorDocument<? extends V>> toDocumentFn;
    private HazelcastWriters.ArrayMap<Object, VectorDocument<?>> buffer;
    private VectorCollection<K, V> collection;
    private Consumer<T> addToBuffer;

    private WriteVectorCollectionP(@Nonnull HazelcastInstance instance, int maxParallelAsyncOps, @Nonnull String collectionName, @Nonnull SerializationService serializationService, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, VectorDocument<? extends V>> toDocumentFn) {
        super(instance, maxParallelAsyncOps);
        this.collectionName = collectionName;
        this.serializationService = serializationService;
        this.toKeyFn = toKeyFn;
        this.toDocumentFn = toDocumentFn;
        this.resetBuffer();
    }

    @Override
    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.collection = VectorCollection.getCollection(this.instance(), this.collectionName);
        boolean hasCustomSerializers = this.serializationService instanceof DelegatingSerializationService && ((DelegatingSerializationService)this.serializationService).hasAddedSerializers();
        this.addToBuffer = !hasCustomSerializers ? item -> this.buffer.add(new AbstractMap.SimpleEntry<K, VectorDocument<V>>(this.key(item), this.document(item))) : item -> this.buffer.add(new AbstractMap.SimpleEntry(this.serializationService.toData(this.key(item)), VectorUtil.serialize(this.document(item), this.serializationService)));
    }

    private K key(T item) {
        return this.toKeyFn.apply(item);
    }

    private VectorDocument<? extends V> document(T item) {
        return this.toDocumentFn.apply(item);
    }

    @Override
    protected void processInternal(Inbox inbox) {
        if (this.buffer.size() < 1024) {
            inbox.drain(this.addToBuffer);
        }
        this.submitPending();
    }

    @Override
    protected boolean flushInternal() {
        return this.submitPending();
    }

    private boolean submitPending() {
        if (this.buffer.isEmpty()) {
            return true;
        }
        if (!this.tryAcquirePermit()) {
            return false;
        }
        this.setCallback(this.collection.putAllAsync(this.buffer));
        this.resetBuffer();
        return true;
    }

    private void resetBuffer() {
        this.buffer = new HazelcastWriters.ArrayMap(1024);
    }

    public static Permission vectorCollectionPutPermission(String collectionName) {
        return new VectorCollectionPermission(collectionName, "create", "put");
    }

    @BinaryInterface
    public static class Supplier<T, K, V>
    extends AbstractHazelcastConnectorSupplier {
        private static final long serialVersionUID = 1L;
        private static final int MAX_PARALLELISM = 16;
        private final String collectionName;
        private final FunctionEx<? super T, ? extends K> toKeyFn;
        private final FunctionEx<? super T, VectorDocument<? extends V>> toDocumentFn;
        private int maxParallelAsyncOps;

        public Supplier(String collectionName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, VectorDocument<? extends V>> toDocumentFn) {
            super(null, null);
            this.collectionName = collectionName;
            this.toKeyFn = toKeyFn;
            this.toDocumentFn = toDocumentFn;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            super.init(context);
            this.maxParallelAsyncOps = Integer.max(1, 16 / context.localParallelism());
        }

        @Override
        protected Processor createProcessor(HazelcastInstance instance, SerializationService serializationService) {
            return new WriteVectorCollectionP<T, K, V>(instance, this.maxParallelAsyncOps, this.collectionName, serializationService, this.toKeyFn, this.toDocumentFn);
        }

        @Override
        public List<Permission> permissions() {
            return List.of(WriteVectorCollectionP.vectorCollectionPutPermission(this.collectionName));
        }
    }
}

