/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.jet;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.ServiceFactories;
import com.hazelcast.jet.pipeline.ServiceFactory;
import com.hazelcast.jet.pipeline.StreamStage;
import com.hazelcast.security.permission.VectorCollectionPermission;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.VectorCollection;
import com.hazelcast.vector.VectorValues;
import java.security.Permission;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

@Beta
public final class VectorTransforms {
    private VectorTransforms() {
    }

    @Nonnull
    public static <T, K, V, R> FunctionEx<StreamStage<T>, StreamStage<R>> mapUsingVectorSearch(@Nonnull String collectionName, @Nonnull SearchOptions options, @Nonnull FunctionEx<T, VectorValues> toVectorFn, @Nonnull BiFunctionEx<T, SearchResults<K, V>, R> resultFn) {
        return s -> s.mapUsingServiceAsync(VectorTransforms.factory(collectionName), (collection, item) -> VectorTransforms.search(collection, options, toVectorFn, resultFn, item)).setName("mapUsingVectorCollectionSearch");
    }

    @Nonnull
    public static <T, K, V, R> FunctionEx<StreamStage<T>, StreamStage<R>> mapUsingVectorSearch(@Nonnull VectorCollection<K, V> collection, @Nonnull SearchOptions options, @Nonnull FunctionEx<T, VectorValues> toVectorFn, @Nonnull BiFunctionEx<T, SearchResults<K, V>, R> resultFn) {
        return VectorTransforms.mapUsingVectorSearch(collection.getName(), options, toVectorFn, resultFn);
    }

    @Nonnull
    public static <T, K, V, R> FunctionEx<BatchStage<T>, BatchStage<R>> mapUsingVectorSearchBatch(@Nonnull String collectionName, @Nonnull SearchOptions options, @Nonnull FunctionEx<T, VectorValues> toVectorFn, @Nonnull BiFunctionEx<T, SearchResults<K, V>, R> resultFn) {
        return s -> s.mapUsingServiceAsync(VectorTransforms.factory(collectionName), (collection, item) -> VectorTransforms.search(collection, options, toVectorFn, resultFn, item)).setName("mapUsingVectorCollectionSearch");
    }

    @Nonnull
    public static <T, K, V, R> FunctionEx<BatchStage<T>, BatchStage<R>> mapUsingVectorSearchBatch(@Nonnull VectorCollection<K, V> collection, @Nonnull SearchOptions options, @Nonnull FunctionEx<T, VectorValues> toVectorFn, @Nonnull BiFunctionEx<T, SearchResults<K, V>, R> resultFn) {
        return VectorTransforms.mapUsingVectorSearchBatch(collection.getName(), options, toVectorFn, resultFn);
    }

    private static <T, K, V, R> CompletableFuture<R> search(@Nonnull VectorCollection<K, V> collection, @Nonnull SearchOptions options, @Nonnull FunctionEx<T, VectorValues> toVectorFn, @Nonnull BiFunctionEx<T, SearchResults<K, V>, R> resultFn, T item) {
        return collection.searchAsync(toVectorFn.apply(item), options).toCompletableFuture().thenApplyAsync(sr -> resultFn.apply(item, (SearchResults)sr), ConcurrencyUtil.CALLER_RUNS);
    }

    private static <K, V> ServiceFactory<?, VectorCollection<K, V>> factory(@Nonnull String collectionName) {
        return ServiceFactories.sharedService(VectorTransforms.vectorCollectionFn(collectionName)).withPermission(VectorTransforms.vectorCollectionSearchPermission(collectionName));
    }

    private static <K, V> FunctionEx<? super ProcessorSupplier.Context, VectorCollection<K, V>> vectorCollectionFn(final String name) {
        return new FunctionEx<ProcessorSupplier.Context, VectorCollection<K, V>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public VectorCollection<K, V> applyEx(ProcessorSupplier.Context context) {
                return VectorCollection.getCollection(context.hazelcastInstance(), name);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(VectorTransforms.vectorCollectionSearchPermission(name));
            }
        };
    }

    private static VectorCollectionPermission vectorCollectionSearchPermission(String collectionName) {
        return new VectorCollectionPermission(collectionName, "create", "read");
    }
}

