/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage.graph;

import com.hazelcast.shaded.io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.similarity.BuildScoreProvider;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.similarity.SearchScoreProvider;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorUtil;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorFloat;
import com.hazelcast.vector.impl.storage.UpdatableVectorsSource;
import com.hazelcast.vector.impl.storage.graph.HazelcastVectorSimilarityFunction;
import java.util.function.Supplier;

public class HazelcastBuildScoreProvider
implements BuildScoreProvider {
    private final Supplier<RandomAccessVectorValues> vectors;
    private final Supplier<RandomAccessVectorValues> vectorsCopy;
    private final HazelcastVectorSimilarityFunction similarityFunction;

    public HazelcastBuildScoreProvider(RandomAccessVectorValues vectorsSource, HazelcastVectorSimilarityFunction similarityFunction) {
        this.vectors = vectorsSource.threadLocalSupplier();
        this.vectorsCopy = vectorsSource.threadLocalSupplier();
        this.similarityFunction = similarityFunction;
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public VectorFloat<?> approximateCentroid() {
        UpdatableVectorsSource vv = (UpdatableVectorsSource)this.vectors.get();
        VectorFloat<?> centroid = vts.createFloatVector(vv.dimension());
        vv.entries().forEach(entry -> {
            VectorFloat v = (VectorFloat)entry.getValue();
            VectorUtil.addInPlace(centroid, v);
        });
        VectorUtil.scale(centroid, 1.0f / (float)vv.size());
        return centroid;
    }

    @Override
    public SearchScoreProvider searchProviderFor(VectorFloat<?> vector) {
        RandomAccessVectorValues vc = this.vectorsCopy.get();
        return this.getSearchScoreProviderExact(vector, vc);
    }

    @Override
    public SearchScoreProvider searchProviderFor(int node1) {
        RandomAccessVectorValues randomAccessVectorValues = this.vectors.get();
        VectorFloat<?> v = randomAccessVectorValues.getVector(node1);
        return this.searchProviderFor(v);
    }

    @Override
    public SearchScoreProvider diversityProviderFor(int node1) {
        RandomAccessVectorValues randomAccessVectorValues = this.vectors.get();
        VectorFloat<?> v = randomAccessVectorValues.getVector(node1);
        RandomAccessVectorValues vc = this.vectorsCopy.get();
        return this.getSearchScoreProviderExact(v, vc);
    }

    private SearchScoreProvider getSearchScoreProviderExact(final VectorFloat<?> vector, final RandomAccessVectorValues ravv) {
        ScoreFunction.ExactScoreFunction sf = new ScoreFunction.ExactScoreFunction(){

            @Override
            public float similarityTo(int node2) {
                return HazelcastBuildScoreProvider.this.similarityFunction.compare(vector, ravv.getVector(node2));
            }
        };
        return new SearchScoreProvider(sf);
    }
}

