/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage;

import com.hazelcast.internal.memory.Measurable;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorFloat;
import com.hazelcast.shaded.org.jctools.maps.NonBlockingHashMapLong;
import com.hazelcast.vector.impl.storage.ArrayVectorProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class UpdatableVectorsSource
implements RandomAccessVectorValues,
Measurable {
    static final long FIXED_HEAP_BYTES_USED = (long)JVMUtil.OBJECT_HEADER_SIZE + (long)JVMUtil.REFERENCE_COST_IN_BYTES + 4L + 8L;
    private static final int INITIAL_CAPACITY = 1024;
    final long heapBytesUsedPerEntry;
    private final NonBlockingHashMapLong<VectorFloat<?>> data = new NonBlockingHashMapLong(1024);
    private final int dimension;

    public UpdatableVectorsSource(int dimension) {
        this.dimension = dimension;
        long vectorFloatHeapBytesUsed = (long)(JVMUtil.OBJECT_HEADER_SIZE + JVMUtil.REFERENCE_COST_IN_BYTES + JVMUtil.OBJECT_HEADER_SIZE + 4) + (long)dimension * 4L;
        this.heapBytesUsedPerEntry = vectorFloatHeapBytesUsed + 8L + (long)JVMUtil.REFERENCE_COST_IN_BYTES;
    }

    public boolean add(int id, VectorFloat<?> vector) {
        return this.data.put(id, vector) != null;
    }

    public boolean remove(int id) {
        return this.data.remove(id) != null;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public VectorFloat<?> getVector(int i) {
        return this.data.get(i);
    }

    @Override
    public boolean isValueShared() {
        return false;
    }

    @Override
    public RandomAccessVectorValues copy() {
        return this;
    }

    @Override
    public long heapBytesUsed() {
        return FIXED_HEAP_BYTES_USED + (long)this.data.size() * this.heapBytesUsedPerEntry;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.data.size());
        for (Map.Entry<Long, VectorFloat<?>> vectorEntry : this.data.entrySet()) {
            out.writeInt(vectorEntry.getKey().intValue());
            out.writeFloatArray((float[])vectorEntry.getValue().get());
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        int vectorsCount = in.readInt();
        for (int k = 0; k < vectorsCount; ++k) {
            int nodeId = in.readInt();
            float[] vectorArray = in.readFloatArray();
            this.add(nodeId, ArrayVectorProvider.getInstance().createFloatVector(vectorArray));
        }
    }

    public Set<Map.Entry<Long, VectorFloat<?>>> entries() {
        return Collections.unmodifiableSet(this.data.entrySet());
    }
}

