/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage;

import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorFloat;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.storage.ArrayVectorProvider;
import com.hazelcast.vector.impl.storage.VectorCollectionObjectProvider;

public class OnHeapVectorCollectionObjectProvider
implements VectorCollectionObjectProvider {
    @Override
    public VectorCollectionObjectProvider.VectorFloatConverter createVectorFloatConverter() {
        return new VectorCollectionObjectProvider.VectorFloatConverter(){

            @Override
            public VectorFloat<?> toVectorFloat(float[] vector) {
                return ArrayVectorProvider.getInstance().createFloatVector(vector);
            }

            @Override
            public float[] toFloatArray(VectorFloat<?> vectorFloat) {
                return (float[])vectorFloat.get();
            }

            @Override
            public VectorValues createSingleVectorValue(VectorFloat<?> vectorFloat) {
                float[] floatArray = (float[])vectorFloat.get();
                return VectorValues.of(floatArray);
            }
        };
    }

    public static VectorCollectionObjectProvider getInstance() {
        return Holder.INSTANCE;
    }

    private static VectorCollectionObjectProvider createOnHeapTypeSupport() {
        return new OnHeapVectorCollectionObjectProvider();
    }

    private static final class Holder {
        static final VectorCollectionObjectProvider INSTANCE = OnHeapVectorCollectionObjectProvider.createOnHeapTypeSupport();

        private Holder() {
        }
    }
}

