/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.internal.util.collection.Hashing;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;

public class Int2FloatArrayHashMap {
    public static final double DEFAULT_LOAD_FACTOR = 0.6;
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    private final float[] nullValue;
    private final double loadFactor;
    private final int dimensions;
    private int resizeThreshold;
    private int capacity;
    private int mask;
    private int size;
    private int[] keys;
    private float[][] values;
    private final ValueCollection valueCollection = new ValueCollection();
    private final KeySet keySet = new KeySet();
    private final EntrySet entrySet = new EntrySet();

    public Int2FloatArrayHashMap(int dimensions) {
        this(8, 0.6, dimensions);
    }

    public Int2FloatArrayHashMap(int initialCapacity, int dimensions) {
        this(initialCapacity, 0.6, dimensions);
    }

    public Int2FloatArrayHashMap(int initialCapacity, double loadFactor, int dimensions) {
        this.loadFactor = loadFactor;
        this.dimensions = dimensions;
        this.nullValue = new float[dimensions];
        this.capacity = QuickMath.nextPowerOfTwo(initialCapacity);
        this.mask = this.capacity - 1;
        this.resizeThreshold = (int)((double)this.capacity * loadFactor);
        this.keys = new int[this.capacity];
        this.values = new float[this.capacity][dimensions];
        this.initializeValues(this.values);
    }

    public double loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.capacity;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return 0 == this.size;
    }

    public boolean containsKey(int key) {
        int index = Hashing.intHash(key, this.mask);
        while (this.nullValue != this.values[index]) {
            if (key == this.keys[index]) {
                return true;
            }
            ++index;
            index &= this.mask;
        }
        return false;
    }

    public float[] get(int key) {
        float[] value;
        int index = Hashing.intHash(key, this.mask);
        while (this.nullValue != (value = this.values[index])) {
            if (key == this.keys[index]) {
                return value;
            }
            ++index;
            index &= this.mask;
        }
        return null;
    }

    public float[] computeIfAbsent(int key, IntFunction<float[]> mappingFunction) {
        Preconditions.checkNotNull(mappingFunction, "mappingFunction cannot be null");
        float[] value = this.get(key);
        if (value == null && (value = mappingFunction.apply(key)) != null) {
            this.put(key, value);
        }
        return value;
    }

    public float[] put(int key, float[] value) {
        Preconditions.checkNotNull(value, "Value cannot be null");
        float[] oldValue = null;
        int index = Hashing.intHash(key, this.mask);
        while (this.nullValue != this.values[index]) {
            if (key == this.keys[index]) {
                oldValue = this.values[index];
                break;
            }
            ++index;
            index &= this.mask;
        }
        if (null == oldValue) {
            ++this.size;
            this.keys[index] = key;
        }
        this.values[index] = value;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return oldValue == this.nullValue ? null : oldValue;
    }

    public float[] remove(int key) {
        float[] value;
        int index = Hashing.intHash(key, this.mask);
        while (this.nullValue != (value = this.values[index])) {
            if (key == this.keys[index]) {
                this.values[index] = this.nullValue;
                --this.size;
                this.compactChain(index);
                return value;
            }
            ++index;
            index &= this.mask;
        }
        return null;
    }

    public void clear() {
        this.size = 0;
        this.initializeValues(this.values);
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / this.loadFactor));
        this.rehash(QuickMath.nextPowerOfTwo(idealCapacity));
    }

    public KeySet keySet() {
        return this.keySet;
    }

    public Collection<float[]> values() {
        return this.valueCollection;
    }

    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value, "Null values are not permitted");
        for (float[] v : this.values) {
            if (this.nullValue == v || !value.equals(v)) continue;
            return true;
        }
        return false;
    }

    public Set<Map.Entry<Integer, float[]>> entrySet() {
        return this.entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<Integer, float[]> entry : this.entrySet()) {
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(Arrays.toString(entry.getValue()));
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    private void increaseCapacity() {
        int newCapacity = this.capacity << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        if (1 != Integer.bitCount(newCapacity)) {
            throw new IllegalStateException("New capacity must be a power of two");
        }
        this.capacity = newCapacity;
        this.mask = newCapacity - 1;
        this.resizeThreshold = (int)((double)newCapacity * this.loadFactor);
        int[] tempKeys = new int[this.capacity];
        float[][] tempValues = new float[this.capacity][this.dimensions];
        this.initializeValues(tempValues);
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            float[] value = this.values[i];
            if (this.nullValue == value) continue;
            int key = this.keys[i];
            int newHash = Hashing.intHash(key, this.mask);
            while (this.nullValue != tempValues[newHash]) {
                ++newHash;
                newHash &= this.mask;
            }
            tempKeys[newHash] = key;
            tempValues[newHash] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        int index = deleteIndex;
        while (true) {
            ++index;
            if (this.nullValue == this.values[index &= this.mask]) {
                return;
            }
            int hash = Hashing.intHash(this.keys[index], this.mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            this.keys[deleteIndex] = this.keys[index];
            this.values[deleteIndex] = this.values[index];
            this.values[index] = this.nullValue;
            deleteIndex = index;
        }
    }

    private void initializeValues(float[][] values) {
        for (int i = 0; i < this.capacity; ++i) {
            values[i] = this.nullValue;
        }
    }

    private class ValueCollection
    extends AbstractCollection<float[]> {
        private ValueCollection() {
        }

        @Override
        public int size() {
            return Int2FloatArrayHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2FloatArrayHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return Int2FloatArrayHashMap.this.containsValue(o);
        }

        @Override
        @Nonnull
        public ValueIterator<float[]> iterator() {
            return new ValueIterator<float[]>();
        }

        @Override
        public void clear() {
            Int2FloatArrayHashMap.this.clear();
        }
    }

    public class KeySet
    extends AbstractSet<Integer> {
        @Override
        public int size() {
            return Int2FloatArrayHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2FloatArrayHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Integer) {
                Integer i = (Integer)o;
                return Int2FloatArrayHashMap.this.containsKey(i);
            }
            return false;
        }

        public boolean contains(int key) {
            return Int2FloatArrayHashMap.this.containsKey(key);
        }

        @Nonnull
        public KeyIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Integer) {
                Integer i = (Integer)o;
                return null != Int2FloatArrayHashMap.this.remove(i);
            }
            return false;
        }

        public boolean remove(int key) {
            return null != Int2FloatArrayHashMap.this.remove(key);
        }

        @Override
        public void clear() {
            Int2FloatArrayHashMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<Integer, float[]>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return Int2FloatArrayHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2FloatArrayHashMap.this.isEmpty();
        }

        @Override
        @Nonnull
        public Iterator<Map.Entry<Integer, float[]>> iterator() {
            return new EntryIterator();
        }

        @Override
        public void clear() {
            Int2FloatArrayHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends AbstractIterator<Map.Entry<Integer, float[]>>
    implements Map.Entry<Integer, float[]> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<Integer, float[]> next() {
            this.findNext();
            return this;
        }

        @Override
        public Integer getKey() {
            return this.keys[this.getPosition()];
        }

        @Override
        public float[] getValue() {
            return this.values[this.getPosition()];
        }

        @Override
        public float[] setValue(float[] value) {
            Preconditions.checkNotNull(value);
            int pos = this.getPosition();
            float[] oldValue = this.values[pos];
            this.values[pos] = value;
            return oldValue;
        }
    }

    public class KeyIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return this.keys[this.getPosition()];
        }
    }

    private class ValueIterator<T>
    extends AbstractIterator<T> {
        private ValueIterator() {
        }

        @Override
        public T next() {
            this.findNext();
            return (T)this.values[this.getPosition()];
        }
    }

    private abstract class AbstractIterator<T>
    implements Iterator<T> {
        protected final int[] keys;
        protected final float[][] values;
        private int posCounter;
        private int stopCounter;
        private boolean isPositionValid;

        protected AbstractIterator() {
            this.keys = Int2FloatArrayHashMap.this.keys;
            this.values = Int2FloatArrayHashMap.this.values;
            int i = Int2FloatArrayHashMap.this.capacity;
            if (Int2FloatArrayHashMap.this.nullValue != this.values[Int2FloatArrayHashMap.this.capacity - 1]) {
                int size = Int2FloatArrayHashMap.this.capacity;
                for (i = 0; i < size && Int2FloatArrayHashMap.this.nullValue != this.values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + Int2FloatArrayHashMap.this.capacity;
        }

        protected int getPosition() {
            return this.posCounter & Int2FloatArrayHashMap.this.mask;
        }

        @Override
        public boolean hasNext() {
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & Int2FloatArrayHashMap.this.mask;
                if (Int2FloatArrayHashMap.this.nullValue == this.values[index]) continue;
                return true;
            }
            return false;
        }

        protected void findNext() {
            this.isPositionValid = false;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & Int2FloatArrayHashMap.this.mask;
                if (Int2FloatArrayHashMap.this.nullValue == this.values[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                return;
            }
            throw new NoSuchElementException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            int position;
            if (this.isPositionValid) {
                position = this.getPosition();
                this.values[position] = Int2FloatArrayHashMap.this.nullValue;
                --Int2FloatArrayHashMap.this.size;
            } else {
                throw new IllegalStateException();
            }
            Int2FloatArrayHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }
    }
}

