/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.service;

import com.hazelcast.config.Config;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.MutableInteger;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.vector.impl.VectorCollectionService;
import com.hazelcast.vector.impl.service.UnlicensedVectorCollectionServiceImpl;
import com.hazelcast.vector.impl.service.VectorCollectionPhoneHomeMetrics;
import java.util.ArrayList;

public class VectorCollectionMetricsProvider
implements MetricsProvider {
    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        VectorCollectionService service = (VectorCollectionService)node.getNodeEngine().getServiceOrNull("hz:service:vector");
        if (service == null || service instanceof UnlicensedVectorCollectionServiceImpl) {
            context.collect(VectorCollectionPhoneHomeMetrics.VECTOR_COLLECTION_LICENSED, Boolean.FALSE);
            return;
        }
        Config config = node.getConfig();
        int vcCount = config.getVectorCollectionConfigs().size();
        MutableInteger vcIndexCount = new MutableInteger();
        ArrayList vcIndexDimensions = new ArrayList();
        config.getVectorCollectionConfigs().forEach((name, vcc) -> {
            vcIndexCount.addAndGet(vcc.getVectorIndexConfigs().size());
            vcc.getVectorIndexConfigs().forEach(vic -> vcIndexDimensions.add(Integer.toString(vic.getDimension())));
        });
        context.collect(VectorCollectionPhoneHomeMetrics.VECTOR_COLLECTION_LICENSED, Boolean.TRUE);
        context.collect(VectorCollectionPhoneHomeMetrics.VECTOR_COLLECTION_COUNT, vcCount);
        context.collect(VectorCollectionPhoneHomeMetrics.VECTOR_COLLECTION_INDEX_COUNT, vcIndexCount.value);
        context.collect(VectorCollectionPhoneHomeMetrics.VECTOR_COLLECTION_INDEX_DIMENSIONS, String.join((CharSequence)",", vcIndexDimensions));
        context.collect(VectorCollectionPhoneHomeMetrics.VECTOR_COLLECTION_HEAP_USAGE, service.heapBytesUsed());
    }
}

